package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeTargetReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/6/3 13:38
 * @Description: 执行问句-指标
 */
@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.TARGET)
public class AgileDataProcessTargetServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService{

    @Resource
    private ADEService adeService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        // 唯一序列顶替actionId
        Long generateSerialNo = event.getGenerateSerialNo();
        Map<String, Object> eventMap = CommonUtil.convertObjectToMap(event.getQuerySchemaReqDTO());
        String question = MapUtils.getString(event.getMsgBody(), "text");
        try {
            //模拟快照,压测用
            String snapId = MapUtils.getString(event.getMsgBody(), "snapshotId", null);
            if (!StringUtils.isEmpty(snapId)) {
                log.info("快照ID：{},处理开始时间：{}", snapId, TimeUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss:SSS"));
            }
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                    , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(event.getMsgBody()));
            for (Map<String, Object> data : querySchemaResDTO.getData().getDataflow()) {
                if (!Objects.isNull(data.get("data")) && "1".equals(String.valueOf(data.get("code")))) {
                    event.setCombinationQuestion(MapUtils.getString(data, "combinationQuestion"));
                    AdeTargetReqDTO adeTargetReqDTO = AdeTargetReqDTO.buildAdeReq(MapUtils.getMap(data,"data"), event);
                    // 请求ade
                    this.sendMessageToAde(adeTargetReqDTO, event);
                } else {
                    Object obj = MapUtils.getObject(data, "sentences", null);
                    List<String> sentences = Lists.newArrayList();
                    if (obj instanceof Collection) {
                        sentences = CommonUtil.objConvertListString(obj);
                    }
                    this.saveQuerySchemaErrorByCode(event,sentences);
                }
            }
         } catch (Exception e) {
            this.saveQuerySchemaErrorByCode(event,null);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句出参：{},耗时:{}ms",
                event.getUser().getUserId(), event.getUser().getUserName(),
                event.getUser().getTenantId(), event.getUser().getTenantName(), question,
                JsonUtils.objectToString(event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook);
    }

    /**
     * 调用ade 和发送b 娜消息
     * @param newAdeSceneReqDTO ade req
     * @param event 问句 事件信息
     */
    public void sendMessageToAde(AdeTargetReqDTO newAdeSceneReqDTO, AthenaMessageEvent event) {
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        String question = MapUtils.getString(event.getMsgBody(),"text");

        try{
            Map<String,Object> response = adeService.reqTargetSnapShotData(newAdeSceneReqDTO,event);
            Map<String,Object> sendMap = Maps.newHashMap();
            if(response == null || MapUtils.getMap(response, "data") == null){
                String errorMsg = MapUtils.getString(response, "msg");
                sendMap.put("prompt",errorMsg);
                //记录异常日志
                String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
                this.saveAbnormal(event,tipMessage,0);
            }else{
                String snapshotId = MapUtils.getString(MapUtils.getMap(response, "data"), "snapshotId");
                sendMap.put("snapshotId",snapshotId);
            }
            semcService.sendMessageToGpt(event,sendMap);

            this.saveQuestionData(MapUtils.getMap(response, "data"),event,question,combinationQuestion,generateSerialNo);
        }catch (Exception e){
            Map<String,Object> sendMap = Maps.newHashMap();
            sendMap.put("prompt",e.getMessage());
            //记录异常日志
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormal(event,tipMessage,0);
            semcService.sendMessageToGpt(event,sendMap);
        }
    }
}
