package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;


@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.AI_BOARD_ANALYZE)
public class SchemaDataProcessAIBoardAnalyzeServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {
    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private SchemaDataProcessMetricServiceImpl schemaDataProcessMetricService;
    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        try{
            schema = chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "AIBoardSchemaPostReq", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "AIBoardSchemaPost", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        // dataset ppt
        return this.checkSchemaResponseData(event,schema);
    }

    /**
     * 1.语义返回校验 dataflow/metric
     * 2.metric 多目标/多场景/多应用/导正 判断返回
     * @param event 上下文
     * @param querySchemaResDTO 语义返回
     * @return 校验后上下文和语义实体
     */
    public Pair<Boolean, QuerySchemaResDTO> checkSchemaResponseData(AthenaMessageEvent event,
                                                                    QuerySchemaResDTO querySchemaResDTO) {

        if (querySchemaResDTO == null || StringUtils.isEmpty(querySchemaResDTO.getData().getMethod())
                || (CollectionUtils.isEmpty(querySchemaResDTO.getData().getDataflow())
                && (Objects.isNull(querySchemaResDTO.getData().getMetric())
                && Objects.isNull(querySchemaResDTO.getData().getDataset())))){
            return Pair.of(false, null);
        }

        boolean check;
        String method = querySchemaResDTO.getData().getMethod();
        // 确定存储上下文后续链路类型 dataflow/method
        this.setAthenaEventMethod(event,method);
        Pair<Boolean, QuerySchemaResDTO> result;
        if (method.equals(SchemaConstants.METHOD_DATASET)) {
            check = schemaDataProcessMetricService.checkDatasetResponseData(querySchemaResDTO, event);
            result = check ? Pair.of(true, querySchemaResDTO) : Pair.of(false, querySchemaResDTO);
            querySchemaResDTO.setRoute(SchemaDataEnum.AI_BOARD_ANALYZE.getCode());
//            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "datasetAnalysis", LogUtils.SUCCESS,
//                    JsonUtils.objectToString(querySchemaResDTO), JsonUtils.objectToString(result), "");
        } else {
            result = Pair.of(false, null);
        }
        return result;
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {

        return null;
    }

    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }
}
