package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.ATTRIBUTION_SUMMARY)
public class SchemaDataProcessAttributionSummaryServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {
    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        return null;
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaAutoDataReportReq(event);
        req.setParam(MapUtils.getMap(event.getMsgExt(),"attributionAnalyze"));
        try{
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), "", "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap(req);
    }

    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }
}
