package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.AutoDataQuestionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2025/8/27 13:20
 * @Description: auto data 问答
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.AUTO_DATA_QUESTION)
public class SchemaDataProcessAutoDataQuestionServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private EchoService echoService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private SemcService semcService;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {

        return null;
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        event.getQuerySchemaReqDTO().setQuestion(event.getQuestion());
        event.getQuerySchemaReqDTO().setProbe(true);
        event.getQuerySchemaReqDTO().setMultiDialogue(true);
        event.getQuerySchemaReqDTO().setEnableDataSearch(MapUtils.getBoolean(event.getMsgExt(),"enableDataSearch",true));
        return CommonUtil.convertObjectToMap(event.getQuerySchemaReqDTO());
    }

    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }

    /**
     * auto data 特殊返回
     * @param event e
     * @param req r
     * @return res
     */
    public AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult processAutoData(AthenaMessageEvent event, Map<String, Object> req) {

        AutoDataQuestionResDTO res = new AutoDataQuestionResDTO();
        // 发送sse 消息
        SseEmitter sseEmitter = event.getSseEmitter();
        try{
            res = chatbiService.getIntentionConfirm(event,req);
            if(res == null || res.getData() == null){
                String sysError = messageUtil.getMessageByLangNameWithFormat(
                        "message.system.schema.error",event.getLang());
                String[] answerSplit = sysError.split("");
                for (int i = 0; i < sysError.length(); i++) {
                    Thread.sleep(15);
                    EventData.EventMessage eventMessage  = EventData.EventMessage.builderAnswerTextMessage(answerSplit[i]);
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
                }
                this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(),sseEmitter,new EventData.EventMessage());
                this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(),sseEmitter,new EventData.EventMessage());
                sseEmitter.complete();
                return null;
            }
            String resultMsg;
            if(res.getData().getCode() == 1){
                resultMsg = res.getData().getReply();
            }else{
                resultMsg = res.getData().getRecognitionResult().getReplay();
            }
            String[] answerSplit = resultMsg.split("");
            for (int i = 0; i < resultMsg.length(); i++) {
                Thread.sleep(15);
                EventData.EventMessage eventMessage  = EventData.EventMessage.builderAnswerTextMessage(answerSplit[i]);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
            }
            if(res.getData().getCode() == 1){
                if(res.getData().getRecognitionResult() != null){
                    Map<String,Object> sendMap = new HashMap<>();
                    sendMap.put("recognitionResult",res.getData().getRecognitionResult());
                    semcService.sendMessageToGpt(event,sendMap);
                } else {
                    this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
                    this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
                    sseEmitter.complete();
                }
                return null;
            }
            Object title = res.getData().getRecognitionResult().getBlueprint().get("title");
            AgileDataAutoDataDTO agileDataAutoDataDTO = new AgileDataAutoDataDTO();
            agileDataAutoDataDTO.setMessageId(event.getGenerateSerialNo());
            agileDataAutoDataDTO.setFileName(Objects.nonNull(title) ? title.toString() : "");
            echoService.saveAutoDataReport(event.getUser(),agileDataAutoDataDTO);
        }catch (Exception e){
            log.error("获取语义意图信息异常，{}",e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
      return res.getData().getRecognitionResult();
    }
}
