package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AgileDataProcessDesignerServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AgileDataProcessMetricServiceImpl;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:54
 * @Description: debug schema
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.DEBUG)
public class SchemaDataProcessDebugServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private AgileDataProcessDesignerServiceImpl agileDataProcessDesignerServiceImpl;



    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        String question = event.getQuestion();
        // 语义识别入参
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        // 关闭多轮
        req.setMultiDialogue(false);
        // 1.0 解析组装提问入参
        QuerySchemaDebugDTO querySchemaDebugDTO = assembleQuestionByMsg(question.trim());
        // 解析后的debug问句
        String debugQuestion = querySchemaDebugDTO.getQuestion();
        if (question.contains("*debug*")) {
            // debug 语义调用
            return this.debugProcess(event,req,querySchemaDebugDTO,debugQuestion);
        }else if (question.contains("*test")){
            return this.testDebugProcess(event,req,querySchemaDebugDTO,debugQuestion);
        }else if (question.contains("*pr-debug*")) {
            // 2.1 不调用语义,组装语义实体
            return Pair.of(true, QuerySchemaResDTO.builderPrDebug(querySchemaDebugDTO));
        }
        return null;
    }

    /**
     * DEBUG 语义解析
     * @param event 上下文
     * @param req 语义请求
     * @param querySchemaDebugDTO 语义请求
     * @param debugQuestion 问句
     * @return 封装体
     */
    public Pair<Boolean, QuerySchemaResDTO> debugProcess(AthenaMessageEvent event,
                                                         QuerySchemaReqDTO req,
                                                         QuerySchemaDebugDTO querySchemaDebugDTO,
                                                         String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try{
            // 2.0 透传kmCode编码给语义
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            // 2.0.1 重新定义问句
            req.setMessage(debugQuestion);
            // debug标识
            req.setDebugMode("3");
            schema = chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debug", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debug", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return absCheckSchemaResponseData(event,schema);
    }

    /**
     * TEST-DEBUG 语义解析
     * @param event 上下文
     * @param req 语义请求
     * @param querySchemaDebugDTO 语义请求
     * @param debugQuestion 问句
     * @return 封装体
     */
    public Pair<Boolean, QuerySchemaResDTO> testDebugProcess(AthenaMessageEvent event,
                                                         QuerySchemaReqDTO req,
                                                         QuerySchemaDebugDTO querySchemaDebugDTO,
                                                         String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try{
            // 2.0 透传kmCode编码给语义
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            // 2.0.1 重新定义问句
            req.setMessage(debugQuestion);
            // debug标识
            req.setDebugMode("4");
            schema = chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "test", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "test", TroubleToolCodeEnum.ADT_901_0110.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0110.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0110.getSuggestion());
        }
        return absCheckSchemaResponseData(event,schema);
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {

        String question = event.getQuestion();
        // 语义识别入参
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        // 关闭多轮
        req.setMultiDialogue(false);
        // 1.0 解析组装提问入参
        QuerySchemaDebugDTO querySchemaDebugDTO = assembleQuestionByMsg(question.trim());
        // 解析后的debug问句
        String debugQuestion = querySchemaDebugDTO.getQuestion();
        if (question.contains("*debug*")) {
            // debug 语义调用
            return this.debugSseReq(req,querySchemaDebugDTO,debugQuestion);
        }else if (question.contains("*test")){
            return this.testDebugSseReq(req,querySchemaDebugDTO,debugQuestion);
        }else if (question.contains("*pr-debug*")) {
            // 2.1 不调用语义,组装语义实体
            agileDataProcessDesignerServiceImpl.process(event,QuerySchemaResDTO.builderPrDebug(querySchemaDebugDTO));
        }
        return null;
    }

    private Map<String, Object> debugSseReq(QuerySchemaReqDTO req,
                                            QuerySchemaDebugDTO querySchemaDebugDTO,
                                            String debugQuestion) {

        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try{
            // 2.0 透传kmCode编码给语义
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            // 2.0.1 重新定义问句
            req.setMessage(debugQuestion);
            // debug标识
            req.setDebugMode("3");
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "test", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "test", TroubleToolCodeEnum.ADT_901_0110.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0110.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0110.getSuggestion());
        }
        return CommonUtil.convertObjectToMap(req);
    }

    private Map<String, Object> testDebugSseReq(QuerySchemaReqDTO req,
                                                QuerySchemaDebugDTO querySchemaDebugDTO,
                                                String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try{
            // 2.0 透传kmCode编码给语义
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            // 2.0.1 重新定义问句
            req.setMessage(debugQuestion);
            // debug标识
            req.setDebugMode("4");
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debug", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debug", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap(req);
    }

    /**
     * sse 验证语义返回消息
     * @param event 上下文
     * @param jsonObject 语义返回消息实体
     * @return result
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaResDTO.class);
        return absCheckSchemaResponseData(event,querySchemaResDTO);
    }

}
