package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static org.apache.commons.collections.MapUtils.getObject;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 14:01
 * @Description:
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.DESIGNER)
public class SchemaDataProcessDesignerServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        // 标准场景入参构造
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaDesignerReq(event);
        try{
            schema = chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        // 根据语义新老方案区分标识 区分场景或指标数据流校验
        return absCheckSchemaResponseData(event,schema);
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaDesignerReq(event);
        try{
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), "", "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "NumericalIntelligenceMode", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap(req);
    }

    /**
     * 设计器链路
     * 正常语句判断、非正常发送娜娜判断、多轮导正判断、多目标判断、
     * 这里语义返回的 specialMode 目前 1为多目标 2 为多场景 非 messageType 1 和 3,且目前只有 多场景和多目标会返回 其余为null
     * @param querySchemaResDTO 语义返回
     * @param event 消息体
     * @return 是否返回
     */
    public boolean checkDataFlowResponseData(QuerySchemaResDTO querySchemaResDTO, AthenaMessageEvent event) {

        boolean isCheck = true;
        try{
            // 组合问句
            String combinationQuestion = getStringBySchemaData(
                    querySchemaResDTO, SchemaConstants.COMBINATION_QUESTION);
            // 上下文问句
            String questionUnderstand = getStringBySchemaData(
                    querySchemaResDTO,SchemaConstants.QUESTION_UNDERSTAND);
            // 多场景
            List<Map<String, Object>> sceneList = getListBySchemaData(
                    querySchemaResDTO,SchemaConstants.SCENES);
            // 多目标
            List<Map<String, Object>> targetList = getListBySchemaData(
                    querySchemaResDTO,SchemaConstants.TARGETS);
            // 多产品线
            List<Map<String, Object>> productLineInfo = getListBySchemaData(
                    querySchemaResDTO,SchemaConstants.PRODUCT_LINE_INFO);
            event.setCombinationQuestion(combinationQuestion);
            event.setQuestionUnderstand(questionUnderstand);
            event.setScenes(sceneList);
            event.setTargets(targetList);
            // 多产品线上下文
            event.setProductLineInfo(productLineInfo);
            // 获取dataflow 应用信息存储到上下文字
            this.saveDataFlowEventApplicationMessage(event,querySchemaResDTO);
            for(Map<String, Object> data : querySchemaResDTO.getData().getDataflow()){
                Object specialMode = data.get("specialMode");
                if(Objects.nonNull(data.get("code")) && (int) data.get("code") != 1){
                    Map<String, Object> msgBody = new HashMap<>();
                    if(Objects.nonNull(specialMode)){
                        // 上报echo 多目标/多场景消息,并且修改上下文中 adt messageType
                        this.sendSpecialMessage(data,event);
                    }else{
                        msgBody.put("prompt", MapUtils.getString(data, "data"));
                    }
                    msgBody.put("scrumbiQuestion", event.getQuestion());
                    isCheck = false;
                    Object obj = MapUtils.getObject(data,"sentences",null);
                    event.setAnswerResult(2);
                    if(obj instanceof Collection){
                        event.setSentences(CommonUtil.objConvertListString(obj));
                    }
                    if(event.isSendNana()){
                        semcService.sendMessageToGpt(event,msgBody);
                    }
                    String errorMsg = messageUtil.getMessageByLangNameWithFormat("message.morescene.error",
                            event.getLang());
                    this.saveAbnormalLog(event, msgBody.containsKey("prompt") ? MapUtils.getString(msgBody, "prompt") : errorMsg,1,0);
                    break;
                }
            }
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "sceneAnalysis", TroubleToolCodeEnum.ADT_901_0113.getErrCode(),
                    JsonUtils.objectToString(querySchemaResDTO), TroubleToolCodeEnum.ADT_901_0113.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0113.getSuggestion());
        }
        return isCheck;
    }

    /**
     * 获取dataflow 应用信息存储到上下文字
     * @param event 上下文、
     * @param querySchemaResDTO 语义返参
     */
    public void saveDataFlowEventApplicationMessage(AthenaMessageEvent event,QuerySchemaResDTO querySchemaResDTO){
        List<Map<String, Object>> scenesList = querySchemaResDTO.getData().getDataflow().stream()
                .map(data -> {
                    Object scenesObj = getObject(data, "scenes");
                    return scenesObj instanceof List? (List<Map<String, Object>>) (scenesObj) : null;
                })
                .filter(Objects::nonNull)
                .filter(CollectionUtils::isNotEmpty)
                .flatMap(List::stream)
                .collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(scenesList)){
            Map<String, Object> scenesMap = scenesList.get(0);
            event.setAppName(Objects.nonNull(scenesMap.get("appName")) ?
                    String.valueOf(scenesMap.get("appName")): "");
            event.setAppCode(Objects.nonNull(scenesMap.get("appCode")) ?
                    String.valueOf(scenesMap.get("appCode")): "");
        }
    }

    /**
     * sse 验证语义返回消息
     * @param event 上下文
     * @param jsonObject 语义返回消息实体
     * @return result
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaResDTO.class);
        return absCheckSchemaResponseData(event,querySchemaResDTO);
    }

}
