package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.METRIC_DEBUG)
public class SchemaDataProcessMetricDebugServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        String question = event.getQuestion();
        // 1.0 解析组装提问入参
        QuerySchemaDebugDTO querySchemaDebugDTO = assembleQuestionByMsg(question.trim());
        // 语义识别入参
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaMetricDebugReq(event,querySchemaDebugDTO);
        try{
            schema = chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "metric-debug", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(schema), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "metric-debug", TroubleToolCodeEnum.ADT_901_0109.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0109.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0109.getSuggestion());
        }
        return absCheckSchemaResponseData(event,schema);
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        String question = event.getQuestion();
        // 1.0 解析组装提问入参
        QuerySchemaDebugDTO querySchemaDebugDTO = assembleQuestionByMsg(question.trim());
        // 语义识别入参
        return CommonUtil.convertObjectToMap(QuerySchemaReqDTO.
                builderSchemaMetricDebugReq(event,querySchemaDebugDTO));
    }

    /**
     * sse 验证语义返回消息
     * @param event 上下文
     * @param jsonObject 语义返回消息实体
     * @return result
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaResDTO.class);
        return absCheckSchemaResponseData(event,querySchemaResDTO);
    }
}
