package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 14:46
 * @Description: mock 数据
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.MOCK)
public class SchemaDataProcessMockServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    SemcService semcService;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        List<Map<String,Object>> sceneList = new ArrayList<>();
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String question = event.getQuestion();
        if("今年接单金额".equals(question)){
            return Pair.of(true,questionS202405090008());
        }else if ("今年接单趋势".equals(question)) {
            return Pair.of(true,questionS202405090009());
        }else if ("今年接单排名前五的部门".equals(question)){
            return Pair.of(true,questionS202405090016());
        }else if ("今年客户回款金额".equals(question)){
            return Pair.of(true,questionS20240814103533U55AVsNj());
        }else if ("今年各业务员的回款情况".equals(question)){
            return Pair.of(true,questionS202405090032());
        }else if ("今年订单金额准交率".equals(question)){
            String sceneCode = String.valueOf(event.getMsgExt().get("sceneCode"));
            if(StringUtils.isEmpty(sceneCode)){
                String sceneStr = "[{\"sceneCode\":\"S202405090007\",\"billingGoodsId\":\"\",\"appCode\":\"A8325-a1c2\",\"sceneTitle\":\"接單增長率狀況\"},{\"sceneCode\":\"S20240709164038FtYuNC1W\",\"billingGoodsId\":\"1216700ALL000001\",\"appCode\":\"A6af5-145f\",\"sceneTitle\":\"test-接單成長率\"}]";
                Gson gson = new Gson();
                sceneList = gson.fromJson(sceneStr,sceneList.getClass());
                event.setMessageType("1");
                Map<String, Object> messageBody = new HashMap<>();
                messageBody.put("scrumbiQuestion", event.getQuestion());
                messageBody.put("scenes", sceneList);
                sendMessage(event,messageBody);
                return Pair.of(false,questionZunJLv());
            }
            return Pair.of(true,questionZunJLv());
        }else {
            Map<String, Object> msgBody = new HashMap<>();
            msgBody.put("prompt", "未识别到目标");
            sendMessage(event,msgBody);
        }
        return Pair.of(false, querySchemaResDTO);
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        return null;
    }

    public void sendMessage(AthenaMessageEvent event,Map<String, Object> messageBody){
        semcService.sendMessageToGpt(event,messageBody);
    }


    public QuerySchemaResDTO questionS202405090008 (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "{\"code\":200,\"msg\":\"操作成功\",\"data\":[{\"code\":1,\"dimensionCnt\":0,\"data\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}],\"sentences\":[\"上月的订单金额是多少\",\"查询接单增长率，按客户\",\"测试用例\",\"查询接单成长率，按部门\",\"查询接单增长率\",\"查询接单成长率，按产品\",\"本月接单最多的前五大产品\",\"本月接单最差的部门是哪个?\",\"查询今年接单成长率\"],\"totalTime\":6443,\"templateCode\":\"summary\",\"type\":\"KNOWLEDGE_GRAPH\",\"target\":\"theAmountOfTheOrder\",\"questionUnderstand\":\"今年接单金额,筛选出2024-01-01~2024-12-31、订单金额数据\",\"sceneCode\":\"S202405090008\",\"datasourceId\":\"theAmountOfTheOrder\",\"scenes\":[{\"sceneCode\":\"S202405090008\",\"billingGoodsId\":\"\",\"appCode\":\"A8325-a1c2\"}],\"client\":\"RH_HK_GPT4\",\"combinationQuestion\":\"今年接单金额\",\"dimension\":[]}]}";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    public QuerySchemaResDTO questionS202405090009 (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "{\"code\":200,\"msg\":\"操作成功\",\"data\":[{\"code\":1,\"dimensionCnt\":0,\"data\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}],\"sentences\":[\"上月的订单金额是多少\",\"查询接单增长率，按客户\",\"测试用例\",\"查询接单成长率，按部门\",\"查询接单增长率\",\"查询接单成长率，按产品\",\"本月接单最多的前五大产品\",\"本月接单最差的部门是哪个?\",\"查询今年接单成长率\"],\"totalTime\":4760,\"templateCode\":\"trend\",\"type\":\"KNOWLEDGE_GRAPH\",\"target\":\"theAmountOfTheOrder\",\"questionUnderstand\":\"今年接单趋势,筛选出2024-01-01~2024-12-31、订单金额数据\",\"sceneCode\":\"S202405090009\",\"datasourceId\":\"theAmountOfTheOrder\",\"scenes\":[{\"sceneCode\":\"S202405090009\",\"billingGoodsId\":\"\",\"appCode\":\"A8325-a1c2\"}],\"client\":\"RH_HK_GPT4\",\"combinationQuestion\":\"今年接单趋势\",\"dimension\":[]}]}";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    public QuerySchemaResDTO questionS202405090016 (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "{\"code\":200,\"msg\":\"操作成功\",\"data\":[{\"code\":1,\"dimensionCnt\":1,\"data\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"datetime\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"datetime\"}]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"statisticalMethod\":\"limit\",\"startPos\":\"0\",\"endPos\":\"4\",\"direction\":\"head\"}]},\"name\":\"limit\",\"technique\":\"group\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"desc\",\"statisticalFields\":[]}]},\"name\":\"sort\",\"technique\":\"group\"}],\"sentences\":[\"上月的订单金额是多少\",\"查询接单增长率，按客户\",\"测试用例\",\"查询接单成长率，按部门\",\"查询接单增长率\",\"查询接单成长率，按产品\",\"本月接单最多的前五大产品\",\"本月接单最差的部门是哪个?\",\"查询今年接单成长率\"],\"totalTime\":3918,\"templateCode\":\"ranking\",\"type\":\"KNOWLEDGE_GRAPH\",\"target\":\"theAmountOfTheOrder\",\"questionUnderstand\":\"今年接单排名前五的部门,筛选出2024-01-01~2024-12-31的记录，按部门名称分组查看订单金额数据\",\"sceneCode\":\"S202405090016\",\"datasourceId\":\"theAmountOfTheOrder\",\"scenes\":[{\"sceneCode\":\"S202405090016\",\"billingGoodsId\":\"\",\"appCode\":\"A8325-a1c2\"}],\"client\":\"RH_HK_GPT4\",\"combinationQuestion\":\"今年接单排名前五的部门\",\"dimension\":[\"ADMINUNITNAME\"]}]}";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    public QuerySchemaResDTO questionS20240814103533U55AVsNj (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "{\"code\":200,\"msg\":\"操作成功\",\"data\":[{\"code\":1,\"dimensionCnt\":1,\"data\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}],\"sentences\":[\"今年的回款总额？\",\"本月收款最差的部门是哪个？\",\"今年收款金额最高的前3名业务\",\"上月哪个业务员收款金额最高\",\"这个月的收款金额如何？\",\"这个月的各个客户回款总金额？\",\"本月收款最好的部门？\",\"本月客户第一科技的总回款金额？\",\"这个月的各个客户收款总额？\"],\"totalTime\":3952,\"templateCode\":\"summary\",\"type\":\"KNOWLEDGE_GRAPH\",\"target\":\"payment\",\"questionUnderstand\":\"今年客户回款金额,筛选出2024-01-01~2024-12-31的记录，按客户名称分组查看回款数据\",\"sceneCode\":\"S20240814103533U55AVsNj\",\"datasourceId\":\"payment\",\"scenes\":[{\"sceneCode\":\"S20240814103533U55AVsNj\",\"billingGoodsId\":\"\",\"appCode\":\"Afd4c-580b\"}],\"client\":\"RH_HK_GPT4\",\"combinationQuestion\":\"今年客户回款金额\",\"dimension\":[\"CUSTOMERNAME\"]}]}";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    public QuerySchemaResDTO questionS202405090032 (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "{\"code\":200,\"msg\":\"操作成功\",\"data\":[{\"code\":1,\"dimensionCnt\":1,\"data\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}],\"sentences\":[\"今年的回款总额？\",\"本月收款最差的部门是哪个？\",\"今年收款金额最高的前3名业务\",\"上月哪个业务员收款金额最高\",\"这个月的收款金额如何？\",\"这个月的各个客户回款总金额？\",\"本月收款最好的部门？\",\"本月客户第一科技的总回款金额？\",\"这个月的各个客户收款总额？\"],\"totalTime\":3529,\"templateCode\":\"summary\",\"type\":\"KNOWLEDGE_GRAPH\",\"target\":\"payment\",\"questionUnderstand\":\"今年各业务员的回款情况,筛选出2024-01-01~2024-12-31的记录，按业务员分组查看回款数据\",\"sceneCode\":\"S202405090032\",\"datasourceId\":\"payment\",\"scenes\":[{\"sceneCode\":\"S202405090032\",\"billingGoodsId\":\"\",\"appCode\":\"A8325-a1c2\"}],\"client\":\"RH_HK_GPT4\",\"combinationQuestion\":\"今年各业务员的回款情况\",\"dimension\":[\"EMPLOYEENAME\"]}]}";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    public QuerySchemaResDTO questionZunJLv (){
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        String msg = "";
        Gson gson = new Gson();
        return gson.fromJson(msg, querySchemaResDTO.getClass());
    }

    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }

}
