package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.PPT_ANALYZE)
public class SchemaDataProcessPPtAnalyzeServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {
    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        return null;
    }

    @Autowired
    private SemcService semcService;

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaPPTAnalyzeReq(event);
        try{
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "PPTAnalyzeIntelligenceMode", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), "", "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "PPTAnalyzeIntelligenceMode", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap(req);
    }

    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaResDTO.class);
        if (querySchemaResDTO == null || querySchemaResDTO.getCode() == null){
            return Pair.of(false, null);
        }

        boolean check =false;
        Pair<Boolean, QuerySchemaResDTO> result;
        try {
            Object code = querySchemaResDTO.getCode();
            if (Objects.isNull(code)) {
                return Pair.of(false, querySchemaResDTO);
            }
            switch (code.toString()) {
                // 成功分析问句
                case SchemaConstants.METRIC_SQL:
                    check = true;
                    //分析规划结果上传
                    event.setQuestionPlanningRes(querySchemaResDTO.getQuestionPlanningRes());
                    break;
                // 异常引导语句
                case SchemaConstants.SCHEMA_REPLY:
                    String reply = querySchemaResDTO.getReply();
                    Map<String, Object> msgBody = Maps.newHashMap();
                    msgBody.put("prompt", reply);
                    msgBody.put("scrumbiQuestion", event.getQuestion());
                    msgBody.put("answerModel", "replay");
                    msgBody.put("analyzeResult",false);
                    semcService.sendMessageToGpt(event, msgBody);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "pptAnalysis", TroubleToolCodeEnum.ADT_901_0129.getErrCode(),
                    JsonUtils.objectToString(querySchemaResDTO),
                    TroubleToolCodeEnum.ADT_901_0129.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0129.getSuggestion());
        }
        querySchemaResDTO.setRoute(SchemaDataEnum.PPT_ANALYZE.getCode());
        result = check? Pair.of(true, querySchemaResDTO) : Pair.of(false, querySchemaResDTO);
        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "pptAnalysis", LogUtils.SUCCESS,
                JsonUtils.objectToString(querySchemaResDTO), JsonUtils.objectToString(result), "");
        return result;
    }
}
