package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @Author: SunHong
 * @Date: 2024/8/8 15:59
 * @Description: 专线
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.SPECIAL)
public class SchemaDataProcessSpecialServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        Map<String, Object> requestParam = new HashMap<>();
        requestParam.put("message", event.getQuestion());
        QuerySchemaLiteResDTO querySchemaResDTO = chatbiService.getQuerySchemaSpecial(requestParam, event);
       return schemaDataProcessLite(event,querySchemaResDTO);
    }

    /**
     * lite 语义公共实现
     * @param event 上下文
     * @param querySchemaResDTO 语义返回
     * @return res
     */
    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessLite(AthenaMessageEvent event,
                                                                  QuerySchemaLiteResDTO querySchemaResDTO){
        QuerySchemaResDTO result = new QuerySchemaResDTO();
        if (querySchemaResDTO == null || CollectionUtils.isEmpty(querySchemaResDTO.getData())){
            return Pair.of(false, null);
        }
        if(CollectionUtils.isNotEmpty(querySchemaResDTO.getData())){
            querySchemaResDTO.getData().stream().forEach(item->{
                //转换为lite结构
                String code = MapUtils.getString(item, "code");
                if(StringUtils.equals("1", code)){
                    item.put("code", "0");
                } else {
                    item.put("code", "1");
                }
            });
        }
        QuerySchemaDataDTO res = new QuerySchemaDataDTO();
        res.setDataflow(querySchemaResDTO.getData());
        res.setMethod(SchemaDataEnum.SPECIAL.getCode());
        result.setRoute(SchemaDataEnum.SPECIAL.getCode());
        result.setMsg(querySchemaResDTO.getMsg());
        result.setCode(querySchemaResDTO.getCode());
        result.setData(res);
        return Pair.of(true, result);
    }

    /**
     * sse lite 实现
     * @param event 上下文
     * @param jsonObject 语义返回对象
     * @return res
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaLiteResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaLiteResDTO.class);
        return schemaDataProcessLite(event,querySchemaResDTO);
    }

    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        Map<String, Object> requestParam = new HashMap<>();
        requestParam.put("message", event.getQuestion());
        return requestParam;
    }
}
