package com.digiwin.athena.adt.agileReport.service.impl.relation;

import com.digiwin.athena.adt.agileReport.dao.AgileDataSnapRelationMappingMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataSnapRelationMappingService;
import com.digiwin.athena.adt.domain.po.AgileDataSnapRelationMapping;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @Author: SunHong
 * @Date: 2025/7/29 14:22
 * @Description:
 */
@Slf4j
@Service
public class AgileDataSnapRelationMappingServiceImpl implements AgileDataSnapRelationMappingService {

    @Resource
    private AgileDataSnapRelationMappingMapper agileDataSnapRelationMappingMapper;

    @Override
    public void saveSnapshotIdMappingRelation(String orgSnapshotId, String filterSnapshotId) {

        AgileDataSnapRelationMapping mapping = new AgileDataSnapRelationMapping();
        mapping.setOrgSnapshotId(orgSnapshotId);
        mapping.setFilterSnapshotId(filterSnapshotId);
        mapping.setCreateTime(new Date());
        agileDataSnapRelationMappingMapper.insert(mapping);
    }
}
