package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.agileReport.service.AgileDataAssistTroubleService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 11:35
 * @Description:
 */
@Service
@Slf4j
public class AgileProcessAssistTroubleServiceImpl extends AbsAgileDataProcess implements AgileDataAssistTroubleService {

    @Autowired
    private SchemaDataHandlerProcessor schemaDataHandlerProcessor;

    @Autowired
    private ChatbiService chatbiService;

    @Override
    public ResponseEntity<?> getAssistTroubleData(HttpServletRequest request,
                                                  String message,
                                                  String sceneCode,
                                                  AuthoredUser user) {

        AthenaMessageDTO athenaMessageDTO = new AthenaMessageDTO();
        Map<String,Object> extMap = Maps.newHashMap();
        extMap.put("sceneCode",sceneCode);
        extMap.put("question",message);
        athenaMessageDTO.setMsgExt(extMap);
        Map<String,Object> msgBody = Maps.newHashMap();
        msgBody.put("text",message);
        athenaMessageDTO.setMsgBody(msgBody);

        AthenaMessageEvent event = init(request,athenaMessageDTO,user);
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        //场景编码
        req.setSceneCode(MapUtils.getString(event.getMsgExt(), "sceneCode"));
        // 多场景标识 第一轮不传 第二轮 有sceneCode 传3`
        if("3".equals(event.getMessageType())) {
            req.setDebugMode("3");
            // 关闭多轮
            req.setMultiDialogue(false);
        }
        req.setMessage(message);
        QuerySchemaResDTO responseData = chatbiService.getQuerySchema(event.getQuerySchemaReqDTO(), event);

        if (responseData == null || CollectionUtils.isEmpty(responseData.getData().getDataflow())){
            return ResponseEntityWrapper.wrapperOk("访问意图识别失败");
        }
        List<ADEScencDTO> adeScencDTOList = new ArrayList<>();
        List<Map<String, Object>> dataList = responseData.getData().getDataflow();
        List<Map<String,Object>> scenes = Lists.newArrayList();

        for (Map<String, Object> data : dataList) {
            if(MapUtils.isEmpty(data)){
                continue;
            }
            if (data.containsKey("code")) {
                int code = (int) data.get("code");
                switch (code) {
                    case 1:
                        List<Map<String,Object>> sceneList = (List<Map<String, Object>>) MapUtils.getObject(data,"scenes");
                        String kmCode = StringUtils.EMPTY;
                        if(CollectionUtils.isNotEmpty(sceneList)){
                            scenes.addAll(sceneList);
                            Boolean isMore = CollectionUtils.isNotEmpty(scenes) && scenes.size() > 1 ? true : false;
                            //【根据语义返回结果，设定消息类型】
//                            event.setMessageType(getMessageType(event.getMessageType(),message,event.getMsgExt(),isMore,user));
                            //单场景
                            if(CollectionUtils.isNotEmpty(scenes)){
                                kmCode = MapUtils.getString(scenes.get(0),"sceneCode");
                            }
                        } else {
                            kmCode = MapUtils.getString(data, "sceneCode");
                        }
                        ADEScencDTO adeScencDTO = buildCommodeScene(user,event.getSceneDTO());
                        adeScencDTO.setTemplateCode(MapUtils.getString(data, "templateCode"));
                        adeScencDTO.setTarget(MapUtils.getString(data, "target"));
                        adeScencDTO.setDimension(MapUtils.getObject(data, "dimension"));
                        //从KM获取场景code
                        Map<String,Object> sceneMap = Maps.newHashMap();
                        sceneMap.put("templateCode",adeScencDTO.getTemplateCode());
                        sceneMap.put("targetId",adeScencDTO.getTarget());
                        sceneMap.put("dimension",adeScencDTO.getDimension());
                        if(CollectionUtils.isNotEmpty(sceneList) && sceneList.size() > 1){
                            sceneMap.put("errorMsg","存在多场景，请选择一个场景接口加入sceneCode作为入参查询");
                            sceneMap.put("scenes",sceneList);
                            return ResponseEntityWrapper.wrapperOk(sceneMap);
                        }
//                        KMScencDTO kmScencDTO = kmService.getKmSceneCode(sceneMap,request.getHeader("Locale"),user.getToken());
                        if(StringUtils.isEmpty(kmCode)){
                            sceneMap.put("errorMsg","不存在该场景");
                            return ResponseEntityWrapper.wrapperOk(sceneMap);
                        }
                        adeScencDTO.setSceneCode(kmCode);
                        Map<String, Object> recastData = new HashMap<>();
                        recastData.put(kmCode, data.get("data"));
                        adeScencDTO.setRecast(recastData);
                        adeScencDTOList.add(adeScencDTO);
                        break;
                    case 2:
                        ADEScencDTO adeSceneDTO2 = buildCommodeScene(user,event.getSceneDTO());
                        adeSceneDTO2.setQuerySchema(MapUtils.getMap(data, "data"));
                        adeScencDTOList.add(adeSceneDTO2);
                        break;
                    default:
                        Map<String,Object> chartData = Maps.newHashMap();
                        chartData.put("chartData",responseData);
                        chartData.put("errorMsg","语义无法分析此问题");
                        return ResponseEntityWrapper.wrapperOk(chartData);
                }
            }
        }
        //语义解析正确，可通过执行引擎发送消息
        if (CollectionUtils.isNotEmpty(adeScencDTOList)){
            return ResponseEntityWrapper.wrapperOk(adeScencDTOList.get(0));
        }
        return ResponseEntityWrapper.wrapperOk("语义无法分析此问题");
    }

    private ADEScencDTO buildCommodeScene(AuthoredUser user, SceneDTO sceneDTO){
        ADEScencDTO adeScencDTO = new ADEScencDTO();
        adeScencDTO.setTenantId(user.getTenantId());
        adeScencDTO.setRequestor(user.getUserId());
        adeScencDTO.setLocale(LocaleContextHolder.getLocale().toString());
        adeScencDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss"));
        adeScencDTO.setScene(sceneDTO);
        adeScencDTO.setMethod(SchemaConstants.METHOD_DATA_FLOW);
        return adeScencDTO;
    }
}
