package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAbnormalDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportAbnormalService;
import com.digiwin.athena.adt.domain.dto.AgileDataAbnormal;
import com.digiwin.athena.adt.domain.dto.AgileDataAnswerData;
import com.digiwin.athena.adt.domain.dto.AgileDataFeedBack;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class AgileReportAbnormalServiceImpl implements AgileReportAbnormalService {

    @Autowired
    @Qualifier("mongoAgileDataLogTemplate")
    private MongoTemplate mongoAgileDataLogTemplate;

    private static final String MONGODB_ANSWER_COLLECTION_NAME = "agile_data_result_log";

    @Autowired
    private AsyncEventBus localEventBus;


    @Override
    public Boolean saveAbnormal(AuthoredUser authoredUser, AgileDataAbnormalDTO agileDataFeedBackDTO, String clientAgent) {
        AgileDataLogEvent agileDataLogEvent = new AgileDataLogEvent();
        agileDataLogEvent.setAuthoredUser(authoredUser);
        agileDataLogEvent.setGenerateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo());
        agileDataLogEvent.setTerminal(clientAgent);
        agileDataLogEvent.setSnapshotId(agileDataFeedBackDTO.getSnapshotId());
        agileDataLogEvent.setQuestion(agileDataFeedBackDTO.getQuestion());
        agileDataLogEvent.setParams(MapUtils.isEmpty(agileDataFeedBackDTO.getParams()) ? Maps.newHashMap() : agileDataFeedBackDTO.getParams());
        agileDataLogEvent.setType(1);
        agileDataLogEvent.setSuccess(0);
        agileDataLogEvent.setErrorAnswer(agileDataFeedBackDTO.getErrorMsg());
        localEventBus.post(agileDataLogEvent);

        return true;
    }

    @Override
    public Boolean saveAnswerResult(AuthoredUser authoredUser, AgileDataAnswerData agileDataAnswerData) {
        if(agileDataAnswerData != null) {
            mongoAgileDataLogTemplate.insert(agileDataAnswerData, MONGODB_ANSWER_COLLECTION_NAME);
        }
        return true;
    }
}
