package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportFeedBackService;
import com.digiwin.athena.adt.domain.dto.AgileDataFeedBack;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import com.mongodb.client.result.DeleteResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AgileReportFeedBackServiceImpl implements AgileReportFeedBackService {

    @Autowired
    @Qualifier("mongoAgileDataLogTemplate")
    private MongoTemplate mongoAgileDataLogTemplate;

    private static final String MONGODB_COLLECTION_NAME = "agile_data_full_log";

    @Autowired
    private AsyncEventBus localEventBus;

    /**
     * 保存用户反馈
     * @param authoredUser
     * @param agileDataFeedBackDTO
     */
    @Override
    public Boolean saveFeedback(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO,String clientAgent) {
        AgileDataLogEvent event = AgileDataLogEvent.builder()
                .feedbackType(agileDataFeedBackDTO.getFeedbackType())
                .authoredUser(authoredUser)
                .extendInfo(agileDataFeedBackDTO.getExtendInfo())
                .generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo())
                .terminal(clientAgent)
                .snapshotId(agileDataFeedBackDTO.getSnapshotId())
                .type(2)
                .build();
        localEventBus.post(event);

//        Query query = Query.query(Criteria.where("generateSerialNo").is(agileDataFeedBackDTO.getGenerateSerialNo()).and("userId").is(authoredUser.getUserId()).and("tenantId").is(authoredUser.getTenantId()));
//        AgileDataFeedBack agileDataFeedBack = mongoAgileDataLogTemplate.findOne(query, AgileDataFeedBack.class, MONGODB_COLLECTION_NAME);
//        try {
//            if(agileDataFeedBack != null){
//                //数据更新
//                Update update = new Update()
//                        .set("feedbackType", agileDataFeedBackDTO.getFeedbackType())
//                        .set("modifyTime", LocalDateTime.now());
//                mongoAgileDataLogTemplate.updateFirst(query, update, MONGODB_COLLECTION_NAME);
//            } else {
//                //数据新增
//                agileDataFeedBack = AgileDataFeedBack.builder()
//                        .answerBack(MapUtils.isNotEmpty(agileDataFeedBackDTO.getAnswerBack()) ? agileDataFeedBackDTO.getAnswerBack() : Maps.newHashMap())
//                        .extendInfo(MapUtils.isNotEmpty(agileDataFeedBackDTO.getExtendInfo()) ? agileDataFeedBackDTO.getExtendInfo() : Maps.newHashMap())
//                        .generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo())
//                        .terminal(clientAgent)
//                        .snapshotId(agileDataFeedBackDTO.getSnapshotId())
//                        .question(agileDataFeedBackDTO.getQuestion())
//                        .tenantId(authoredUser.getTenantId())
//                        .tenantName(authoredUser.getTenantName())
//                        .userId(authoredUser.getUserId())
//                        .userName(authoredUser.getUserName())
//                        .feedbackType(agileDataFeedBackDTO.getFeedbackType())
//                        .createTime(LocalDateTime.now())
//                        .build();
//                mongoAgileDataLogTemplate.insert(agileDataFeedBack,MONGODB_COLLECTION_NAME);
//            }
//        } catch (Exception e){
//            log.error("保存用户反馈失败，失败原因："+ e.getMessage());
//            return false;
//        }

        return true;
    }

    /**
     * 删除用户反馈
     * @param authoredUser
     * @param agileDataFeedBackDTO
     */
    @Override
    public void deleteFeedback(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO) {
        AgileDataLogEvent event = AgileDataLogEvent.builder()
                .answerOpinion(StringUtils.EMPTY)
                .backContent(StringUtils.EMPTY)
                .checkOpinions(StringUtils.EMPTY)
                .feedbackType(4)
                .authoredUser(authoredUser)
                .generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo())
                .type(4)
                .build();
        localEventBus.post(event);

//        Query removeQuery = new Query(Criteria.where("generateSerialNo").is(agileDataFeedBackDTO.getGenerateSerialNo()).and("userId").is(authoredUser.getUserId()).and("tenantId").is(authoredUser.getTenantId()));
//        mongoAgileDataLogTemplate.remove(removeQuery, MONGODB_COLLECTION_NAME);
    }

    /**
     * 保存反馈内容
     * @param authoredUser
     * @param agileDataFeedBackDTO
     */
    @Override
    public void answerBack(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO) {

        AgileDataLogEvent event = AgileDataLogEvent.builder()
                .answerOpinion(agileDataFeedBackDTO.getAnswerOpinion())
                .backContent(agileDataFeedBackDTO.getBackContent())
                .checkOpinions(agileDataFeedBackDTO.getCheckOpinions())
                .authoredUser(authoredUser)
                .generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo())
                .type(3)
                .build();
        localEventBus.post(event);
        //数据更新
//        Query query = Query.query(Criteria.where("generateSerialNo").is(agileDataFeedBackDTO.getGenerateSerialNo()).and("userId").is(authoredUser.getUserId()).and("tenantId").is(authoredUser.getTenantId()));
//        Update update = new Update()
//                .set("answerBack", agileDataFeedBackDTO.getAnswerBack())
//                .set("modifyTime", LocalDateTime.now());
//        mongoAgileDataLogTemplate.updateFirst(query, update, MONGODB_COLLECTION_NAME);
    }


    /**
     * 获取用户反馈
     * @param authoredUser
     * @param generateSerialNoList
     * @return
     */
    @Override
    public List<AgileDataFeedBack> getFeedback(AuthoredUser authoredUser, List<Long> generateSerialNoList) {
        //数据获取
        Query query = Query.query(Criteria.where("generateSerialNo").in(generateSerialNoList).and("userId").is(authoredUser.getUserId()).and("tenantId").is(authoredUser.getTenantId()));
        List<AgileDataFeedBack> agileDataFeedBacks = mongoAgileDataLogTemplate.find(query,AgileDataFeedBack.class,MONGODB_COLLECTION_NAME);
        return agileDataFeedBacks;
    }
}
