package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataConfigService;
import com.digiwin.athena.adt.domain.dto.ReportIntentionRequestDTO;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.util.agileData.AgileDataExecuteDataRecord;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 敏捷报表数据处理
 */
@Service
public class AgileReportServiceImpl implements AgileReportService {


    @Autowired
    private AgileDataConfigService agileDataConfigService;

    private static final String AGILE_DATA_TOKEN_SIZE_USER = "tokenSizeUser";

    /**
     * 获取敏捷报表明细数据
     * @param agileReportDetailParamsDTO
     * @return
     */
    @Override
    public List<Map<String, Object>> getReportDetailData(AgileReportDetailParamsDTO agileReportDetailParamsDTO) {
        //改为查询DMC
        List<Map<String, Object>> detailData = Lists.newArrayList();
//        if(CollectionUtils.isNotEmpty(agileReportDetailParamsDTO.getParams())){
//            AgileReportDataDTO agileReportDataDTO = this.getReportData(agileReportDetailParamsDTO.getReportId());
//            if(agileReportDataDTO != null){
//                Map<String,Object> hasDataMap = Maps.newHashMap();
//                List<Map<String,Object>> dataList = agileReportDataDTO.getReportData();
//                for(Map<String,Object> data : dataList){
//                    boolean findData = true;
//                    for(TmActionParameterDTO actionParameterDTO : agileReportDetailParamsDTO.getParams()){
//                        //行数据字段不匹配不处理
//                        if(!data.containsKey(actionParameterDTO.getName())){
//                            findData =false;
//                            break;
//                        }
//                        //行数据不匹配不处理
//                        if(!Objects.equals(data.get(actionParameterDTO.getName()),actionParameterDTO.getValue())){
//                            findData =false;
//                            break;
//                        }
//                    }
//                    //按条件拆卸难道当前数据，直接返回
//                    if(findData){
//                        hasDataMap = data;
//                        break;
//                    }
//                }
//                if(MapUtils.isNotEmpty(hasDataMap)) {
//                    //获取明细数据
//                    Object detailObj = hasDataMap.get(agileReportDetailParamsDTO.getSchema());
//                    if(detailObj instanceof Collection){
//                        detailData.addAll((List<Map<String,Object>>)detailObj);
//                    } else {
//                        detailData.add((Map<String,Object>)detailObj);
//                    }
//                }
//            }
//        }
        return detailData;
    }

    /**
     * 根据用户意图，获取报表明细数据
     * @param reportIntentionRequestDTO
     * @return
     */
    @Override
    public List<Map<String, Object>> getIntentionData(ReportIntentionRequestDTO reportIntentionRequestDTO) {
        //调用SD接口，获取意图明细数据
        return null;
    }

    @Override
    public void executeAgileDataByTokenSize(AuthoredUser user,AthenaMessageEvent event, Map<String, Object> adeResult) {
        //转换业务数据，存入流式结果
        int tokenThreshold = 2304;
        AuthoredUser tokenUser = new AuthoredUser();
        tokenUser.setTenantId(AGILE_DATA_TOKEN_SIZE_USER);
        int tokenThresholdObject = (int) agileDataConfigService.getUserValue(tokenUser);
        if(tokenThresholdObject != 0){
            tokenThreshold = tokenThresholdObject;
        }
        AgileDataExecuteDataRecord.executeAgileData(event,adeResult,tokenThreshold);
    }
}
