package com.digiwin.athena.adt.agileReport.service.impl.screenModel;

import com.digiwin.athena.adt.agileReport.service.AgileDataScreenModelService;
import com.digiwin.athena.adt.domain.dto.AgileDataScreenModelDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

/**
 * 大屏模型服务管理
 */
@Service
public class AgileDataScreenModelImpl implements AgileDataScreenModelService {

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    private static final String MONGODB_COLLECTION_NAME = "agile_data_screen_model";


    /**
     * 大屏模型创建
     * @param authoredUser
     * @param agileDataScreenModel
     * @return
     */
    @Override
    public Boolean createAgileDataScreenModel(AuthoredUser authoredUser, AgileDataScreenModelDTO  agileDataScreenModel) {
        String modelId = agileDataScreenModel.getModelId();
        Integer version = agileDataScreenModel.getVersion();
        if(StringUtils.isEmpty(modelId)){
            return false;
        }
        Query query = Query.query(Criteria.where("modelId").is(modelId).and("version").is(version));
        AgileDataScreenModelDTO agileDataModel = mongoAgileDataPageViewTemplate.findOne(query, AgileDataScreenModelDTO.class, MONGODB_COLLECTION_NAME);
        if(agileDataModel == null){
            mongoAgileDataPageViewTemplate.insert(agileDataScreenModel,MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("models",agileDataScreenModel.getModels());
            mongoAgileDataPageViewTemplate.upsert(query,update,AgileDataScreenModelDTO.class,MONGODB_COLLECTION_NAME);
        }

        return true;
    }

    /**
     * 大屏模型查询
     * @param authoredUser
     * @param modelId
     * @return
     */
    @Override
    public AgileDataScreenModelDTO queryAgileDataScreenModel(AuthoredUser authoredUser, String modelId) {
        Query query = Query.query(Criteria.where("modelId").is(modelId).and("version").is(1));
        AgileDataScreenModelDTO agileDataModelDTO = mongoAgileDataPageViewTemplate.findOne(query, AgileDataScreenModelDTO.class, MONGODB_COLLECTION_NAME);
        return agileDataModelDTO;
    }
}
