package com.digiwin.athena.adt.app.config;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Set;

@Component
@Slf4j
public class RegisterEventOnApplicationRunner implements ApplicationRunner {
    @Autowired
    private AsyncEventBus localEventBus;

    @Override
    public void run(ApplicationArguments args) {
        Reflections reflections = new Reflections("com.digiwin.athena.adt", new MethodAnnotationsScanner());
        Set<Method> methods = reflections.getMethodsAnnotatedWith(Subscribe.class);
        if (null != methods ) {
            for(Method method : methods) {
                try {
                    localEventBus.register(SpringUtil.getBean(method.getDeclaringClass()));
                }catch (Exception e ) {
                    log.error(e.getMessage(),e);
                }
            }
        }
    }

}
