package com.digiwin.athena.adt.app.config.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

import java.util.concurrent.*;

@Configuration
@EnableAsync
public class ExecutorConfig {

    @Value("${async.executor.thread.core_pool_size}")
    private int corePoolSize;
    @Value("${async.executor.thread.max_pool_size}")
    private int maxPoolSize;
    @Value("${async.executor.thread.queue_capacity}")
    private int queueCapacity;
    @Value("${async.executor.thread.keepAliveTime}")
    private long keepAliveTime;
    @Value("${async.executor.thread.name.prefix}")
    private String namePrefix;


    @Bean(name = "asyncServiceExecutor")
    public ExecutorService asyncServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(namePrefix + "_%d").build();

        ThreadPoolExecutor executor = new ThreadPoolMonitor(corePoolSize
                ,maxPoolSize
                ,keepAliveTime
                , TimeUnit.SECONDS
                ,new ArrayBlockingQueue<>(queueCapacity)
                ,queueCapacity
                ,normalThreadFactory
                ,namePrefix
                ,new ThreadPoolExecutor.AbortPolicy());
        return executor;
    }

    @Bean(name = "asyncLogServiceExecutor")
    public ExecutorService asyncLogServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(namePrefix + "_%d").build();

        ThreadPoolExecutor executor = new ThreadPoolMonitor(corePoolSize
                ,maxPoolSize
                ,keepAliveTime
                , TimeUnit.SECONDS
                ,new ArrayBlockingQueue<>(queueCapacity)
                ,queueCapacity
                ,normalThreadFactory
                ,namePrefix
                ,new ThreadPoolExecutor.AbortPolicy());
        return executor;
    }

}
