package com.digiwin.athena.adt.domain.aam.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.aam.AAMService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 敏捷数据操作
 * 废弃 aam 
 */
@Slf4j
@Service
@Deprecated
public class AAMServiceImpl implements AAMService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    private static final String ATMC_LOCAL = "locale";

    /**
     * 敏捷数据上传到文档
     * @param uploadParamDTO
     * @return
     */
    @Override
    public UploadAttachmentResp uploadAgileData(UploadParamDTO uploadParamDTO) {
        String url = envProperties.getAamUri() + "/api/aam/v1/uploadAgileReport";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap<>();
        param.put("fileJson", uploadParamDTO.getFileJson());
        HttpEntity httpEntity = new HttpEntity<>(param, headers);
        try {
            ResponseEntity<BaseResultDTO<UploadAttachmentResp>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<UploadAttachmentResp>>() {
                    });
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "snapshotSave", TroubleToolCodeEnum.ADT_901_0128.getErrCode(),
                    JsonUtils.objectToString(uploadParamDTO), TroubleToolCodeEnum.ADT_901_0128.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0128.getSuggestion());
        } catch (Exception ex) {
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "snapshotSave", TroubleToolCodeEnum.ADT_901_0127.getErrCode(),
                    JsonUtils.objectToString(uploadParamDTO), TroubleToolCodeEnum.ADT_901_0127.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0127.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{} ", ErrorCodeEnum.AAM_UPLOAD_AGILEDATA_FAIL.getErrCode(),JsonUtils.objectToString(uploadParamDTO), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.AAM_UPLOAD_AGILEDATA_FAIL.getErrCode(),ex);
        }
        return null;
    }

    /**
     * 获取文档中的敏捷数据
     * @param fileId
     * @return
     */
    @Override
    public SnapShotDTO getAgileData(String fileId) {
        String url = envProperties.getAamUri() + "/api/aam/v1/getAgileReportInfo?fileId="+fileId;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);

        try {
            ResponseEntity<BaseResultDTO<SnapShotDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<SnapShotDTO>>() {
                    });
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error("{}, 请求fileId：{}, 报错信息：{} ", ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(),fileId, ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(),ex);
        }
    }

    /**
     * 获取文档中的敏捷数据
     * @param fileId
     * @return
     */
    @Override
    public SnapShotDTO getAgileDataByToken(String fileId,String token) {
        String url = envProperties.getAamUri() + "/api/aam/v1/getAgileReportInfo?fileId="+fileId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token",token);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);

        try {
            ResponseEntity<BaseResultDTO<SnapShotDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<SnapShotDTO>>() {
                    });
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error("{}, 请求fileId：{}, 报错信息：{} ", ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(),fileId, ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(),ex);
        }
    }

    /**
     * 删除敏捷报表数据
     * @param fileId
     * @return
     */
    @Override
    public Map<String, Object> deleteAgileData(String fileId) {
        String url = envProperties.getAamUri() + "/api/aam/v1/deleteAgileReportInfo?fileId="+fileId;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);

        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error("{}, 请求fileId：{}, 报错信息：{} ", ErrorCodeEnum.AAM_DELETE_AGILEDATA_FAIL.getErrCode(),fileId, ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.AAM_DELETE_AGILEDATA_FAIL.getErrCode(),ex);
        }
    }

    /**
     * 批量删除敏捷报表数据
     *
     * @param fileIds
     * @return
     */
    @Override
    public Map<String, Object> deleteBatchAgileData(Collection<String> dirIds, Collection<String> fileIds, String token) {
        String url = envProperties.getAamUri() + "/api/aam/v1/batchDeleteAgileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);

        Map<String, Collection<String>> param = new HashMap<>();
        param.put("deleteFileList", fileIds);
        param.put("deleteDirList", dirIds);
        HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            return response.getBody().getResponse();
        } catch (Exception ex) {
            log.error("请求dirIds：{}, 请求fileIds：{}, 报错信息：{} ", dirIds, fileIds, ex);
            throw ex;
        }
    }

}
