package com.digiwin.athena.adt.domain.chatbi;

import com.digiwin.athena.adt.agileReport.controller.dto.*;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTReq;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTRes;
import com.digiwin.athena.adt.domain.dto.ScrumbiPPTAnalyzeDTO;
import com.digiwin.athena.adt.domain.dto.schema.*;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

public interface ChatbiService {

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param reqDTO 语义识别入参
     */
    QuerySchemaResDTO getQuerySchema(QuerySchemaReqDTO reqDTO, AthenaMessageEvent event);

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param msgBody
     */
    QuerySchemaResDTO getQuerySchemaV2(Map<String, Object> msgBody, AthenaMessageEvent event);

    QuerySchemaLiteResDTO getQuerySchemaSpecial(Map<String, Object> requestParam, AthenaMessageEvent event);

    SchemaPushReportResDTO schemaPushReport(AuthoredUser user, AgileDataSpecialUploadReqDTO req);

    QuerySchemaLiteResDTO getQuerySchemaSpecialLite(Map<String, Object> eventMap, AthenaMessageEvent event);

    Map<String, Object> getResultAnalysis(Map<String, Object> param,AuthoredUser user);

    SchemaFluctuateResDTO getFluctuateAnalysis(AthenaMessageEvent event,AnalysisFluctuateReqDTO req);

    SchemaAnalysisAttributionResDTO getAttributionAnalysis(AthenaMessageEvent event, AnalysisAttributionReqDTO req);

    /**
     * 获取问句分析
     * @param user
     * @param params
     * @return
     */
    ScrumbiPPTAnalyzeDTO getPPTAnalyze(AuthoredUser user, Map<String,Object> params, String locale);

    /**
     * PPT生成可执行结构体
     * @param user
     * @param req
     * @param locale
     * @return
     */
    ScrumbiGenaratePPTRes generatePPT(AuthoredUser user, ScrumbiGenaratePPTReq req, String locale);

    AutoDataQuestionResDTO getIntentionConfirm(AthenaMessageEvent event,Map<String, Object> req);
}
