package com.digiwin.athena.adt.domain.chatbi.impl;

import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisFluctuateReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTReq;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTRes;
import com.digiwin.athena.adt.domain.dto.ScrumbiPPTAnalyzeDTO;
import com.digiwin.athena.adt.domain.dto.schema.*;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import java.util.Map;

@Slf4j
@Service
public class ChatbiServiceImpl implements ChatbiService {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private AdtEnvProperties adtEnvProperties;

    @Autowired
    private EchoService echoService;

    @Autowired
    private UserService userService;


    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param querySchemaReqDTO 语义入参实体
     */
   @Override
    public QuerySchemaResDTO getQuerySchema(QuerySchemaReqDTO querySchemaReqDTO, AthenaMessageEvent event) {
//        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat";
       // 原有接口统一替换为流式接口-旧链路,订阅,数据看板关闭流式
       querySchemaReqDTO.setCloseStream(true);
       String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/stream/chat";
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(querySchemaReqDTO,headers);

       long getQuerySchemaTook = System.currentTimeMillis();
       //记录全链路日志
       log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
               ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage(),JsonUtils.objectToString(querySchemaReqDTO)
               ,event.getGenerateSerialNo());
           try {
               ResponseEntity<QuerySchemaResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class);
               log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                       ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage(),
                       JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook
                       ,event.getGenerateSerialNo());
               return response.getBody();
           } catch (ResourceAccessException e){
               log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                       System.currentTimeMillis() - getQuerySchemaTook,
                       BusinessConstants.ERROR_SEND_SCHEMA,
                       BusinessConstants.ERROR_SCHEMA_TIME_OUT,
                       event.getQuestion(),
                       BusinessConstants.ERROR_TIME_OUT_MESSAGE);
               echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA_TIME_OUT,event.getQuestion()
                               ,BusinessConstants.ERROR_TIME_OUT_MESSAGE,"1"),
                       event.getUser().getToken(), event.getUser().getTenantId());
           } catch (Exception e){
               log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                       ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage()
                       ,JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
               echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA
                               ,event.getQuestion(),  String.valueOf(e),"1"),
                       event.getUser().getToken(), event.getUser().getTenantId());
           }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param msgBody
     */
    @Override
    public QuerySchemaResDTO getQuerySchemaV2(Map<String, Object> msgBody, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/v2/chat";

        msgBody.put("gptModel",adtEnvProperties.getChatGptModel());
        msgBody.put("gptProvider","RH");
        msgBody.put("strategy",adtEnvProperties.getChatStrategy());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(msgBody,headers);

        long getQuerySchemaTook = System.currentTimeMillis();

        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message"),JsonUtils.objectToString(msgBody));
            try {
                ResponseEntity<QuerySchemaResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class);
                log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                        ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message"),
                        JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
                return response.getBody();
            } catch (ResourceAccessException e){
                log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                        System.currentTimeMillis() - getQuerySchemaTook,
                        BusinessConstants.ERROR_SEND_SCHEMA,
                        BusinessConstants.ERROR_SCHEMA_TIME_OUT,
                        event.getQuestion(),
                        BusinessConstants.ERROR_TIME_OUT_MESSAGE);
                echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA_TIME_OUT,event.getQuestion()
                                ,BusinessConstants.ERROR_TIME_OUT_MESSAGE,"1"),
                        event.getUser().getToken(), event.getUser().getTenantId());
            } catch (Exception e){
                log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                        ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message")
                        ,JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
                echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA
                                ,event.getQuestion(),  String.valueOf(e),"1"),
                        event.getUser().getToken(), event.getUser().getTenantId());
            }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param requestParam
     */
    @Override
    public QuerySchemaLiteResDTO getQuerySchemaSpecial(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat/demo";

        requestParam.put("gptModel",adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider","RH");
        requestParam.put("message",event.getQuestion());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),JsonUtils.objectToString(requestParam));
        try {
            ResponseEntity<QuerySchemaLiteResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", LogUtils.SUCCESS,
                    JsonUtils.objectToString(requestParam), JsonUtils.objectToString(response), "");
            return response.getBody();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0105.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0105.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0105.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(getQuerySchemaV2)",
                    "调用语义接口超时 ResourceAccessException",
                    event.getQuestion(),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param requestParam
     */
    @Override
    public QuerySchemaLiteResDTO getQuerySchemaSpecialLite(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat/lite";

        requestParam.put("gptModel",adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider","RH");
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),JsonUtils.objectToString(requestParam));
        try {
            ResponseEntity<QuerySchemaLiteResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", LogUtils.SUCCESS,
                    JsonUtils.objectToString(requestParam), JsonUtils.objectToString(response), "");
            return response.getBody();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0103.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0103.getErrMsg(), TroubleToolCodeEnum.ADT_901_0103.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(getQuerySchemaV2)",
                    "调用语义接口超时 ResourceAccessException",
                    event.getQuestion(),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public SchemaPushReportResDTO schemaPushReport(AuthoredUser user, AgileDataSpecialUploadReqDTO req) {
        String url= adtEnvProperties.getFileparsing()+ "/fileparsing/pushReport/v2";

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("Routerkey",user.getTenantId());
        headers.set("tenantId",user.getTenantId());
        headers.set("userId",user.getUserId());
        headers.set("locale",req.getLocale());
        HttpEntity httpEntity = new HttpEntity(req,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(),JsonUtils.objectToString(req));
        try {
            ResponseEntity<SchemaPushReportResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<SchemaPushReportResDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            return response.getBody();
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(pushReport/v2)",
                    "调用语义接口超时 ResourceAccessException",
                    req,
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义出参：{},耗时:{}s",user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public Map<String, Object> getResultAnalysis(Map<String, Object> param, AuthoredUser user) {
        // 获取用户语言别
        String userLocale = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        log.info("userLocale : {}," ,userLocale);

        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/resultAnalysis";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
        headers.set("locale",userLocale);
        HttpEntity httpEntity = new HttpEntity(param,headers);
        log.info("resultAnalysis headers : {}," ,JsonUtils.objectToString(headers));
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "数据总结",JsonUtils.objectToString(param));
        try {
            ResponseEntity<Map<String, Object>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<Map<String, Object>>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据总结",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getResultAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(param), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getResultAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据总结",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public SchemaFluctuateResDTO getFluctuateAnalysis(AthenaMessageEvent event,AnalysisFluctuateReqDTO req) {
        AuthoredUser user = event.getUser();
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/dataAttribution/fluctuate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
//        headers.set("locale",event.getLang());
        headers.set("ptxId",event.getPtxId());
        headers.set("messageId",event.getGenerateSerialNo().toString());
        HttpEntity httpEntity = new HttpEntity(req,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据波动，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "数据波动",JsonUtils.objectToString(req));
        try {
            ResponseEntity<SchemaFluctuateResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<SchemaFluctuateResDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据波动，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据波动",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据波动，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据波动",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public SchemaAnalysisAttributionResDTO getAttributionAnalysis(AthenaMessageEvent event, AnalysisAttributionReqDTO req) {
        AuthoredUser user = event.getUser();
        // 获取用户语言别
//        String userLocale = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
//        log.info("userLocale : {}," ,userLocale);

        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/dataAttribution";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
//        headers.set("locale",userLocale);
        headers.set("ptxId",event.getPtxId());
        headers.set("messageId",event.getGenerateSerialNo().toString());
        HttpEntity httpEntity = new HttpEntity(req,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据归因，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "数据归因",JsonUtils.objectToString(req));
        try {
            ResponseEntity<SchemaAnalysisAttributionResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<SchemaAnalysisAttributionResDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据归因，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据归因",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据归因，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据归因",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    /**
     * ppt分析规划
     * @param user
     * @param params
     * @param locale
     * @return
     */
    @Override
    public ScrumbiPPTAnalyzeDTO getPPTAnalyze(AuthoredUser user, Map<String, Object> params, String locale) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/question/reGenarate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
        headers.set("locale",locale);
        HttpEntity httpEntity = new HttpEntity(params,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT分析规划，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "数据归因",JsonUtils.objectToString(params));
        try {
            ResponseEntity<ScrumbiPPTAnalyzeDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<ScrumbiPPTAnalyzeDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT分析规划，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据归因",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(params), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(params), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT分析规划，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据归因",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public ScrumbiGenaratePPTRes generatePPT(AuthoredUser user, ScrumbiGenaratePPTReq req, String locale) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/ppt/genarate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
        headers.set("locale",locale);
        HttpEntity httpEntity = new HttpEntity(req,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT生成可执行体，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "PPT生成",JsonUtils.objectToString(req));
        try {
            ResponseEntity<ScrumbiGenaratePPTRes> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<ScrumbiGenaratePPTRes>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT生成可执行体，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "PPT生成",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(req), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getFluctuateAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(req), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取PPT生成可执行体，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "PPT生成",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public AutoDataQuestionResDTO getIntentionConfirm(AthenaMessageEvent event,Map<String,Object> req) {

        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/intention/confirm";
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(req,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), req.get("question"),JsonUtils.objectToString(req)
                ,event.getGenerateSerialNo());
        try {
            ResponseEntity<AutoDataQuestionResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<AutoDataQuestionResDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), req.get("question"),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook
                    ,event.getGenerateSerialNo());
            return response.getBody();
        }catch (Exception e){
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), req.get("question")
                    ,JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA
                            ,event.getQuestion(),  String.valueOf(e),"1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
        }
        return null;
    }
}
