package com.digiwin.athena.adt.domain.dto;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * 敏捷数据日志
 */
@Data
@Builder
public class AgileDataResultLog {

    /**
     * 用户信息
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 端
     */
    private String terminal;

    /**
     * 消息ID
     */
    private Long generateSerialNo;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 问句
     */
    private String question;

    /**
     * 异常信息
     */
    private String  errorAnswer;


    /**
     * 用户意见
     */
    private String answerOpinion;

    /**
     * 反馈勾选项
     */
    private String backContent;

    /**
     * 反馈信息
     */
    private String checkOpinions;


    /**
     * 点赞/点踩 0.点赞 1.点踩
     */
    private Integer feedbackType;

    /**
     * 答题是否成功(0 异常/1 正常)
     */
    private Integer success;

    /**
     * 来源名称
     */
    private String sourceName;

    /**
     * 来源编码
     */
    private String sourceCode;

    /**
     * 应用Id
     */
    private String applicationCode;

    /**
     * 应用名称
     */
    private String applicationName;


    /**
     * 是否被分析
     */
    private String logSaveSuccess;

    /**
     * 错误原因
     */
    private String reason;

    private String productVersion;
    //================================以下信息非必有==========================

    /**
     * 查询参数
     */
    private Map<String,Object> params;

    /**
     * 问题结果业务数据
     */
    private Map<String,Object> data;

    /**
     * 客户端扩展信息
     */
    private Map<String,Object> extendInfo;

    /**
     * 查询sql语句
     */
    private Map<String,Object> querySchema;

    /**
     * 提问时间
     */
    private LocalDateTime createTime;

    /**
     * 反馈时间
     */
    private LocalDateTime createBackTime;

    /**
     * 反馈修改时间
     */
    private LocalDateTime modifyTime;

    /**
     * 回答时间
     */
    private LocalDateTime answerTime;

    /**
     * 提问时长(秒)
     */
    private String resSecTime;

}
