package com.digiwin.athena.adt.domain.dto;

import lombok.Data;

import java.util.List;

@Data
public class AgileDataScreenModelDTO {

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 版本号
     */
    private Integer version;

    /**
     * 布局信息
     */
    private List<Model> models;

    @Data
    public static class Model {
        /**
         * 单元格横坐标
         */
        private Integer x;
        /**
         * 单元格的纵坐标
         */
        private Integer y;


        /**
         * 单元格占据的列数量（宽度）
         */
        private Integer cols;

        /**
         * 单元格占据的行数量（高度）
         */
        private Integer rows;
    }


}
