package com.digiwin.athena.adt.domain.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 敏捷报表数据
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "agile_data")
public class AgileReportDataDTO {

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 用户ID
     */
    private String performerId;

    /**
     * 租户信息
     */
    private String tenantId;


    /**
     * KM报表定义编码
     */
    private String reportCode;

    /**
     * dmcId
     */
    private String dmcId;

    /**
     * 侦测ID
     */
    private String detectionId;

    /**
     * 标题
     */
    private String title;

    /**
     * 已读
     */
    private Integer readCount = 0;


    /**
     * 创建日期
     */
    protected LocalDateTime createDate;

    /**
     * 修改日期
     */
    protected LocalDateTime modifyDate;

}
