package com.digiwin.athena.adt.domain.dto;


import com.digiwin.athena.adt.util.CommonUtil;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

public class ParamBuildWebDTO {


    /**
     * 解析语义结果，返回呈现结构
     * @param params
     * @param question
     * @return
     */
    public static String buildParamModel(List<Map<String,Object>> params,String question){
        if(question.contains("*param*")){
           return ParamBuildWebDTO.buildParamModelByParams(params);
        }
        if(question.contains("*pr-param*")){
            return ParamBuildWebDTO.buildPRParamModelByParams(params);
        }
        return null;
    }

    /**
     * 构建前端返回结果
     * @param params
     * @return
     */
    public static String buildParamModelByParams(List<Map<String,Object>> params){
        StringBuilder paramBuilder = new StringBuilder();
        params.stream().forEach(param -> {
            //构建结论
            Boolean result = MapUtils.getBoolean(param,"result");
            paramBuilder.append("结论：");
            paramBuilder.append(result ? "匹配成功" : "匹配失败");
            paramBuilder.append("\n");
            paramBuilder.append("\n");
            //构建问句
            String question = MapUtils.getString(param,"question",StringUtils.EMPTY);
            paramBuilder.append("问句：");
            paramBuilder.append(question);
            paramBuilder.append("\n");
            //构建场景
            String sceneCode = MapUtils.getString(param,"sceneCode",StringUtils.EMPTY);
            paramBuilder.append("场景：");
            paramBuilder.append(sceneCode);
            paramBuilder.append("\n");
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //构建模板
            Map<String,Object> templateCode = MapUtils.getMap(param,"templateCode",Maps.newHashMap());
            //构建场景模板
            Boolean successTemplate = MapUtils.getBoolean(templateCode,"success");
            paramBuilder.append("场景模板：");
            paramBuilder.append(successTemplate ? "ok" : "error");
            paramBuilder.append("\n");
            //构建场景模板问句
            String questionResult = MapUtils.getString(templateCode,"questionResult",StringUtils.EMPTY);
            paramBuilder.append("问句->");
            paramBuilder.append(questionResult);
            paramBuilder.append("\n");
            //构建场景模板场景
            String sceneResult = MapUtils.getString(templateCode,"sceneResult",StringUtils.EMPTY);
            paramBuilder.append("场景->");
            paramBuilder.append(sceneResult);
            paramBuilder.append("\n");
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //构建目标
            Map<String,Object> traget = MapUtils.getMap(param,"traget",Maps.newHashMap());
            Boolean successTarget = MapUtils.getBoolean(traget,"success");
            paramBuilder.append("目标数据：");
            paramBuilder.append(successTarget ? "ok" : "error");
            paramBuilder.append("\n");
            //构建目标数据问句
            String targetQuestion = MapUtils.getString(traget,"questionResult",StringUtils.EMPTY);
            paramBuilder.append("问句->");
            paramBuilder.append(targetQuestion);
            paramBuilder.append("\n");
            //构建目标数据场景
            String targetResult = MapUtils.getString(traget,"sceneResult",StringUtils.EMPTY);
            paramBuilder.append("场景->");
            paramBuilder.append(targetResult);
            paramBuilder.append("\n");
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //构建维度
            Map<String,Object> dimension = MapUtils.getMap(param,"dimension",Maps.newHashMap());
            Boolean successDimension = MapUtils.getBoolean(dimension,"success");
            paramBuilder.append("维度：");
            paramBuilder.append(successDimension ? "ok" : "error");
            paramBuilder.append("\n");
            //构建维度问句
            List<String> dimensionQuestion = (List<String>) MapUtils.getObject(dimension,"questionResult");
            if(CollectionUtils.isNotEmpty(dimensionQuestion)) {
                dimensionQuestion.forEach(item -> {
                    paramBuilder.append("问句->");
                    paramBuilder.append(item);
                    paramBuilder.append("\n");
                });
            } else {
                paramBuilder.append("问句->");
                paramBuilder.append("\n");
            }
            //构建维度场景
            List<String> dimensionResult = (List<String>) MapUtils.getObject(dimension,"sceneResult");
            if(CollectionUtils.isNotEmpty(dimensionResult)) {
                dimensionResult.forEach(item -> {
                    paramBuilder.append("场景->");
                    paramBuilder.append(item);
                    paramBuilder.append("\n");
                });
            } else {
                paramBuilder.append("场景->");
                paramBuilder.append("\n");
            }
        });
        return paramBuilder.toString();
    }

    /**
     * pr-param调式模式返回前端结果
     * @param params
     * @return
     */
    public static String buildPRParamModelByParams(List<Map<String,Object>> params){
        StringBuilder paramBuilder = new StringBuilder();
        params.forEach(param -> {
            //构建场景
            String sceneCode = MapUtils.getString(param,"sceneCode",StringUtils.EMPTY);
            paramBuilder.append("场景编号：");
            paramBuilder.append(sceneCode);
            paramBuilder.append("\n");
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //场景
            Map<String,Object> sceneCondition = MapUtils.getMap(param,"sceneCondition",Maps.newHashMap());
            //场景模板
            String templateCode = MapUtils.getString(sceneCondition,"templateCode",StringUtils.EMPTY);
            paramBuilder.append("场景模板：");
            paramBuilder.append(templateCode);
            paramBuilder.append("\n");
            //目标数据
            String traget = MapUtils.getString(sceneCondition,"traget",StringUtils.EMPTY);
            paramBuilder.append("目标数据：");
            paramBuilder.append(traget);
            paramBuilder.append("\n");
            //维度
            List<String> dimension = (List<String>) MapUtils.getObject(sceneCondition,"dimension");
            if(CollectionUtils.isNotEmpty(dimension)) {
                dimension.forEach(item -> {
                    paramBuilder.append("维度：");
                    paramBuilder.append(item);
                    paramBuilder.append("\n");
                });
            } else {
                paramBuilder.append("维度：");
                paramBuilder.append("\n");
            }
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //排序
            Map<String,Object> sort = MapUtils.getMap(param,"sort",Maps.newHashMap());
            //排序字段
            String sortMethod = MapUtils.getString(sort,"sortMethod",StringUtils.EMPTY);
            paramBuilder.append("排序：");
            if(StringUtils.isNotEmpty(sortMethod)){
                paramBuilder.append(sortMethod);
            }
            paramBuilder.append("\n");
            //limit
            String limit = MapUtils.getString(sort,"limit",StringUtils.EMPTY);
            paramBuilder.append("数量：");
            if(StringUtils.isNotEmpty(limit)) {
                paramBuilder.append(limit);
            }
            paramBuilder.append("\n");
            paramBuilder.append("----------");
            paramBuilder.append("\n");
            //操作符
            List<Map<String,Object>> fieldsList = (List<Map<String, Object>>) MapUtils.getObject(param,"fields");
            if(CollectionUtils.isNotEmpty(fieldsList)) {
                fieldsList.forEach(field -> {
                    if(field != null){
                        paramBuilder.append(MapUtils.getString(field,"name"));
                        paramBuilder.append("|");
                        paramBuilder.append(MapUtils.getString(field,"operation"));
                        paramBuilder.append("|");
                        paramBuilder.append(MapUtils.getString(field,"value"));
                        paramBuilder.append("\n");
                    }
                });
            }

        });
        return paramBuilder.toString();
    }

}
