package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaAnalysisAttributionResDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/8/8 14:36
 * @Description:
 */
@Data
public class AdeAnalysisAttributionReqDTO implements Serializable {

    private String userId;

    private String tenantId;

    private String locale;

    private String appCode;

    private String userToken;

    private String productVersion;

    private String method;

    private List<Map<String,Object>> groupedSolutionSteps;

    private List<Map<String,Object>> datasetList;




    public static AdeAnalysisAttributionReqDTO BuildAnalysisAttributionReq(SchemaAnalysisAttributionResDTO scrumAnalysis,
                                                                           AnalysisAttributionReqDTO req,
                                                                           SnapShotDTO orgSnapshotDTO,
                                                                           AuthoredUser user) {

        AdeAnalysisAttributionReqDTO attribution = new AdeAnalysisAttributionReqDTO();
        attribution.setGroupedSolutionSteps(scrumAnalysis.getData().getGroupedSolutionSteps());
        attribution.setUserId(user.getUserId());
        attribution.setTenantId(user.getTenantId());
        attribution.setUserToken(user.getToken());
        attribution.setMethod(AgileDataEnum.DATASET.getCode());
        attribution.setProductVersion(BusinessConstants.VERSION_2);
        attribution.setAppCode(req.getAppCode());
        attribution.setDatasetList(orgSnapshotDTO.getContext().getBizParams().getDatasetList());
        return attribution;
    }
}
