package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/21 14:15
 * @Description: 请求ADE获取数据集字段
 */
@Data
public class AdeDataSetFieldReqDTO implements Serializable {

    private String appCode;

    private String actionId;

    private List<Map<String,Object>> eocMaps;

    private String locale;

    private String messageId;

    private String method;

    private boolean mock;

    private Map<String,Object> param;

    private String requestTime;

    private String requestor;

    private String userId;

    private String tenantId;

    private Map<String,Object> scene;

    public static AdeDataSetFieldReqDTO builderReq(AuthoredUser user, String appCode, String actionId) {
        AdeDataSetFieldReqDTO res = new AdeDataSetFieldReqDTO();
        res.setAppCode(appCode);
        res.setActionId(actionId);
        res.setEocMaps(new ArrayList<>());
        res.setLocale("zh_CN");
        res.setMessageId(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        res.setMethod("dataset");
        res.setMock(false);
        res.setParam(new HashMap<>());
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime nowDate = LocalDateTime.now();
        String nowFormatDate = nowDate.format(sdf);
        res.setRequestTime(nowFormatDate);
        res.setRequestor(user.getUserId());
        res.setTenantId(user.getTenantId());
        res.setUserId(user.getUserId());
        res.setScene(new HashMap<>());
        return res;
    }
}
