package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaMetricDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/9/20 14:42
 * @Description:
 */
@Data
public class AdeMetricReqDTO implements Serializable {

    private List<Map<String,Object>> eocMaps;

    private String locale;

    private String messageId;

    private boolean mock;

    private Map<String,Object> param;

    private String question;

    private String method;

    private Map<String,Object> metric;

    private List<Map<String,Object>> dataTag;

    private SchemaMetricShowDefine showDefine;

    private String requestTime;

    private String requestor;

    private String tenantId;

    private String appCode;

    private List<Map<String,Object>> metricList;


    private SceneDTO scene;

    /**
     * ade解析debug模式
     */
    private String debugMode;

    private Integer dimensionCnt;

    /**
     * 多产品线
     */
    private List<Map<String,Object>> productLineInfo;

    /**
     * 解题思路
     */
    private String explain4Gpt;

    private String productVersion;

    private List<Map<String,Object>> stepFilterAnalysis;

    private boolean filterAnalysis;

    private boolean saveTransResult;

    public static AdeMetricReqDTO BuildMetricAdeReq(AthenaMessageEvent event, QuerySchemaMetricDTO metric) {
        AdeMetricReqDTO adeMetricReqDTO = new AdeMetricReqDTO();
        Map<String,Object> solutionStep = new HashMap<>();
        SchemaMetricShowDefine showDefine = metric.getShowDefine();
        if(Objects.isNull(showDefine) || CollectionUtils.isEmpty(showDefine.getShowType())){
            throw new IllegalArgumentException("语义呈现数据未返回,未找到对应actionId");
        }
        Map<String,Object> param = new HashMap<>();
        // 2.0 订阅消息 写入 特定的type
        if(event.isSubscribe()){
            param.put("type","2");
            param.put("undeletable",event.isUndeletable());
            param.put("asaCode",event.getAsaCode());
            param.put("ruleId",event.getMsgExt().get("ruleId"));
            param.put("chartTitle",event.getMsgExt().get("chartTitle"));
            adeMetricReqDTO.setParam(param);
        }
        String actionId = showDefine.getShowType().get(0).getActionId();
        solutionStep.put(actionId,metric.getSolutionStep());
        adeMetricReqDTO.setEocMaps(metric.getEocMaps());
        adeMetricReqDTO.setMetricList(event.getMetricList());
        adeMetricReqDTO.setAppCode(event.getAppCode());
        adeMetricReqDTO.setLocale(event.getLang());
        adeMetricReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeMetricReqDTO.setParam(param);
        adeMetricReqDTO.setMock(false);
        adeMetricReqDTO.setQuestion(event.getQuestion());
        adeMetricReqDTO.setMethod(SchemaDataEnum.METRIC.getCode());
        adeMetricReqDTO.setScene(event.getSceneDTO());
        adeMetricReqDTO.setMetric(solutionStep);
        adeMetricReqDTO.setDataTag(metric.getDataTag());
        adeMetricReqDTO.setShowDefine(showDefine);
        adeMetricReqDTO.setDimensionCnt(metric.getDimensionCnt());
        adeMetricReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss") );
        adeMetricReqDTO.setRequestor(event.getUser().getUserId());
        adeMetricReqDTO.setTenantId(event.getUser().getTenantId());
        adeMetricReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeMetricReqDTO.setExplain4Gpt(metric.getExplain4Gpt());
        adeMetricReqDTO.setProductVersion(event.getProductVersion());
        adeMetricReqDTO.setSaveTransResult(event.getSaveTransResult());
        //只有指标debug模式,ade会解析执行sql
        if(event.isDebug()){
            adeMetricReqDTO.setDebugMode("metric");
        }
        return adeMetricReqDTO;
    }
}
