package com.digiwin.athena.adt.domain.dto.ade;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/6/6 13:31
 * @Description: 旧poc类 弃用
 */
@Data
@Deprecated
public class MetricAdeSceneReqDTO implements Serializable {

    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 请求用户
     */
    private String requestor;
    /**
     * 请求用户名
     */
    private String requestPersonName;
    /**
     *  元数据ID
     */
    private String actionId;
    /**
     * 请求时间
     */
    private String requestTime;
    /**
     * 语言类别 “zh_CN”
     */
    private String locale;
    /**
     * 场景
     */
    private SceneDTO scene;
    /**
     *语义返回的图谱查询信息
     */
    private Map<String, Object> recastDefine;
    /**
     * ade 扩展
     */
    private Map<String,Object> param;

    private Map<String,Object> showDefine;
    /**
     * 请求类型 target/designer
     */
    private String requestType;
    /**
     * 语言类别 “zh_CN”
     */
    private String applicationCode;
    /**
     * 场景
     */
    private String version;

    @Deprecated
    public static MetricAdeSceneReqDTO buildAdeReq(Map<String, Object> data, AthenaMessageEvent event) {
        MetricAdeSceneReqDTO metricAdeSceneReqDTO = new MetricAdeSceneReqDTO();
        String actionId = String.valueOf(SnowflakeIdWorker.getInstance().newId());
        Map<String,Object> msgExt = event.getMsgExt();

        // 2.0 订阅消息 写入 特定的type
        if(!Objects.isNull(msgExt) && !Objects.isNull(msgExt.get("type"))
                && "agileSubscribe".equals(String.valueOf(msgExt.get("type"))) ){
            Map<String,Object> param = MapUtil.newHashMap();
            param.put("type","2");
            metricAdeSceneReqDTO.setParam(param);
        }
        metricAdeSceneReqDTO.setTenantId(event.getUser().getTenantId());
        metricAdeSceneReqDTO.setRequestor(event.getUser().getUserId());
        metricAdeSceneReqDTO.setRequestPersonName(event.getUser().getUserName());
        metricAdeSceneReqDTO.setLocale(LocaleContextHolder.getLocale().toString());
        metricAdeSceneReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss"));
        metricAdeSceneReqDTO.setScene(event.getSceneDTO());
        metricAdeSceneReqDTO.setActionId(actionId);
        metricAdeSceneReqDTO.setVersion(event.getVersion());
        metricAdeSceneReqDTO.setApplicationCode(event.getAppCode());
        Map<String,Object> recast = MapUtil.newHashMap();
        List<Map<String,Object>> show = (List<Map<String, Object>>) data.get("show");
        List<Map<String,Object>> showType = (List<Map<String, Object>>) data.get("showType");
        List<Map<String,Object>> dataList = new ArrayList<>();
        dataList.add(data);
        recast.put(actionId,dataList);
        metricAdeSceneReqDTO.setRecastDefine(recast);
        Map<String,Object> showDefine = MapUtil.newHashMap();
        if(CollectionUtils.isNotEmpty(showType)){
            showType.forEach(dto -> dto.put("actionId",actionId));
        }
        showDefine.put("show",show);
        showDefine.put("showType",showType);
        metricAdeSceneReqDTO.setRequestType("metric");
        metricAdeSceneReqDTO.setShowDefine(showDefine);

        return metricAdeSceneReqDTO;
    }
}
