package com.digiwin.athena.adt.domain.dto.agileDataProcess;

import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: SunHong
 * @Date: 2024/7/2 14:22
 * @Description: ade 流程返回信息
 */
@Data
public class AgileDataProcessResDTO implements Serializable {

    private String snapshotId;

    private LocalDateTime requestTime;

    private String msg;

    private boolean isAlarm;

    private int remainingUsage;

    private int totalUsage;

    private String dataTipMessage;

    private SnapShotDTO panelMap;

    public static AgileDataProcessResDTO init() {
        AgileDataProcessResDTO agileDataProcessResDTO = new AgileDataProcessResDTO();
        agileDataProcessResDTO.setAlarm(false);
        agileDataProcessResDTO.setRemainingUsage(0);
        agileDataProcessResDTO.setTotalUsage(0);
        agileDataProcessResDTO.setRequestTime(LocalDateTime.now());
        agileDataProcessResDTO.setSnapshotId("");
        agileDataProcessResDTO.setMsg("");
        return agileDataProcessResDTO;
    }
}
