package com.digiwin.athena.adt.domain.dto.agileReport;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * @Author: SunHong
 * @Date: 2024/5/23 17:09
 * @Description: aamResData
 */
@Data
@Slf4j
public class AamDataResDTO implements Serializable {

    private String sceneCode;

    /**
     * 解析aam返回信息
     * 24 * 3600 * 1000 缓存1天
     * @return AamDataResDTO
     */
    public static AamDataResDTO builderAamDataBySnapShotDTO(SnapShotDTO snapShotDTO, StringRedisTemplate stringRedisTemplate) {
            AamDataResDTO aamDataResDTO = new AamDataResDTO();
            Optional.ofNullable(snapShotDTO)
                    .map(SnapShotDTO::getContext)
                    .filter(context -> !CollectionUtils.isEmpty(context.getPullData()))
                    .ifPresent(context -> {
                        String sceneCode = context.getPullData().get(0).getSceneCode();
                        if(StringUtils.isEmpty(sceneCode)){
                            return;
                        }
                        aamDataResDTO.setSceneCode(sceneCode);
                        stringRedisTemplate.opsForValue().set(snapShotDTO.getSnapshotId(), sceneCode, 24 * 3600 * 1000, TimeUnit.SECONDS);
                        log.info("adt builderAamDataBySnapShotDTO sceneCode:{}",sceneCode);
                    });
            return aamDataResDTO;
    }
}
