package com.digiwin.athena.adt.domain.dto.agileReport;

import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/4/18 9:45
 * @Description:
 */
@Data
public class SnapDataDTO {

    private Integer id;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 发起人ID
     */
    private String performerId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 侦测ID
     */
    private String detectionId;

    /**
     * 处理时间
     */
    private LocalDateTime requestTime;

    /**
     * 文档中心ID
     */
    private String dmcId;

    /**
     * 读取次数ID
     */
    private Integer readCount;

    /**
     * 快照标题
     */
    private String title;

    /**
     * 是否完成 0：未完成，1：已完成
     */
    private Integer status;

    /**
     * 是否完成 0：图谱，1：资产中心
     */
    private String queryType;

    /**
     * 创建时间
     */
    private LocalDateTime createDate;

    /**
     * 修改时间
     */
    private LocalDateTime modifyDate;

    /**
     * 场景编码
     */
    private String code;

    /**
     * 区别入口
     * 0：侦测 1：实时
     */
    private Integer entry;

    /**
     * 删除失败计数器
     */
    private Integer deleteFailed;

    /**
     * 维度区间
     */
    private Map<String,Object> dimensionInterval;

    /**
     * 维度粒度
     */
    private List<SchemaMetricShowDefine.AliasGrain> aliasGrain;

    /**
     * 维度个数
     */
    private Integer dimensionCnt;

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * 转换结果提示
     */
    private String transTips;
}
