package com.digiwin.athena.adt.domain.dto.aiBoard;

import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AIBoardDTO {


    /**
     * 消息ID
     */
    private Long messageId;

    /**
     * 看板ID
     */
    private String boardId;

    /**
     * 消息状态0.未执行 1.已执行 2.执行中
     */
    private Integer messageStatus;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 看板标题
     */
    private String boardTitle;

    /**
     * 预览布局
     */
    private AIBoardLayout previewLayout;

    /**
     * 看板布局
     */
    private AIBoardLayout boardLayout;

    /**
     * 规划问句集合
     */
    private List<AIBoardQuestionDTO> questionInfo;

    @Data
    public static class AIBoardQuestionDTO{

        /**
         * 规划问句ID
         */
        private Long questionId;

        /**
         * 分析规划问句
         */
        private String question;

        /**
         * 区域标题
         */
        private String chartTitle;

        /**
         * 推荐呈现类型
         */
        private String showType;

        /**
         * 分组信息
         */
        private Map<String,Object> chartAttribute;

        /**
         * 取数入参
         */
        private Map<String,Object> getDataParams;

        /**
         * 问句分析状态
         * 0.成功1.失败2.分析中
         */
        private Integer analyzeStatus;

        /**
         * 分析结果
         */
        private AIBoardAnalyzeDTO analyzeResult;

        /**
         * 数据集集合
         */
        private List<String> datasetIds;

        /**
         * 执行解析问数的唯一key
         */
        private Long analyzeMessageId;
    }

    @Data
    public static class AIBoardAnalyzeDTO{
        /**
         * 问句分析推理
         */
        private Map<String,Object> questionAnalysic;

        /**
         * 字段校验
         */
        private Map<String,Object> schemasCheck;

        /**
         * 构建解题思路
         */
        private Map<String,Object> questionWay;

        /**
         * 解题要素识别
         */
        private Map<String,Object> stepAnasisly;

        /**
         * 生成查询方案
         */
        private Map<String,Object> queryPlan;

        /**
         * 解题要素识别
         */
        private Map<String,Object> queryData;
    }


}
