package com.digiwin.athena.adt.domain.dto.aim;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.domain.po.AgileDataLog;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/5/27 17:20
 * @Description: aim req 信息
 */
@Data
public class AimBuildReqDTO implements Serializable {

    private SnapData snapData;

    private String asaCode;

    private AuthoredUser authoredUser;

    private MessageUtil messageUtil;

    private String userLang;

    private String question;

    private String chartTitle;

    private String method;

    private List<Map<String,Object>> metricList;

    private List<Map<String,Object>> datasetList;

    private boolean undeletable;

    private String dataTipMessage;

    private String ruleId;

    /**
     * 筛选条件json
     */
    private List<Map<String,Object>> stepFilterAnalysis;

    private List<Map<String,Object>> stepAnalysis;

    /**
     * 组装aim 入参信息
     * @param authoredUser 用户信息
     * @param snapData 快照信息
     * @param userService 获取语言类别
     * @param messageUtil 多语言信息
     * @return aim req
     */
    public static AimBuildReqDTO builderAimReqDTO(AuthoredUser authoredUser,
                                                  SnapData snapData,
                                                  UserService userService,
                                                  MessageUtil messageUtil) {
        AimBuildReqDTO aimBuildReqDTO = new AimBuildReqDTO();
        String userLangName = userService.getUserLangNameByUserId(
                authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        QueryWrapper<AgileDataLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", authoredUser.getUserId())
                .eq("user_name", authoredUser.getUserName())
                .eq("snapshot_id",snapData.getSnapshotId());
        aimBuildReqDTO.setUserLang(userLangName);
        aimBuildReqDTO.setMessageUtil(messageUtil);
        aimBuildReqDTO.setAuthoredUser(authoredUser);
        aimBuildReqDTO.setSnapData(snapData);
        return aimBuildReqDTO;
    }
}
