package com.digiwin.athena.adt.domain.dto.cac;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: SunHong
 * @Date: 2024/7/24 15:15
 * @Description:
 */
@Data
public class CacDecreaseReq implements Serializable {

    /**
     * 服務id
     */
    private String goodsCode;

    /**
     * 租户
     */
    private String tenantId;

    /**
     * 模組id
     */
    private String moduleId;

    /**
     *  可有字段  备注：扣减次数，大于0
     */
    private Integer decreaseCount;


    public static CacDecreaseReq builderCacDecrease(AthenaMessageEvent event) {
        CacDecreaseReq req = new CacDecreaseReq();
        req.setDecreaseCount(1);
        req.setModuleId(event.getAppCode());
        req.setGoodsCode(event.getGoodsCode());
        req.setTenantId(event.getUser().getTenantId());
        return req;
    }
}
