package com.digiwin.athena.adt.domain.dto.cac;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: SunHong
 * @Date: 2024/7/24 16:20
 * @Description: cac goods info
 */
@Data
public class CacGoods implements Serializable {

    @JsonProperty("purchaseId")
    private String purchaseId;

    @JsonProperty("customerId")
    private String customerId;

    @JsonProperty("tenantId")
    private String tenantId;

    @JsonProperty("id")
    private String id;

    @JsonProperty("code")
    private String code;

    @JsonProperty("itemId")
    private String itemId;

    @JsonProperty("categoryId")
    private String categoryId;

    @JsonProperty("displayName")
    private String displayName;

    @JsonProperty("version")
    private String version;

    @JsonProperty("lastStrategyId")
    private String lastStrategyId;

    @JsonProperty("effectiveTime")
    private String effectiveTime;

    @JsonProperty("authOpen")
    private boolean authOpen;

    @JsonProperty("expiredTime")
    private String expiredTime;

    @JsonProperty("expired")
    private boolean expired;

    @JsonProperty("bufferPeriod")
    private boolean bufferPeriod;

    @JsonProperty("createTime")
    private String createTime;

    @JsonProperty("modifyDate")
    private String modifyDate;

    @JsonProperty("memo")
    private String memo;

    @JsonProperty("multiLogin")
    private boolean multiLogin;

    @JsonProperty("paymentType")
    private int paymentType;

    @JsonProperty("totalUserCount")
    private int totalUserCount;

    @JsonProperty("userCount")
    private int userCount;

    @JsonProperty("totalUsage")
    private int totalUsage;

    @JsonProperty("remainingUsage")
    private int remainingUsage;

    @JsonProperty("customUnit")
    private String customUnit;

    @JsonProperty("countSettings")
    private List<CountSetting> countSettings;

    @JsonProperty("enabledModules")
    private List<EnabledModule> enabledModules;

    @JsonProperty("customAttributes")
    private List<CustomAttribute> customAttributes;

    @JsonProperty("initialize")
    private int initialize;

    @JsonProperty("expireNotice")
    private String expireNotice;

    @JsonProperty("monthlyUsage")
    private int monthlyUsage;

    @JsonProperty("monthlyPlan")
    private boolean monthlyPlan;

    // Getters and Setters for all fields.
}

class CountSetting {
    @JsonProperty("countingId")
    private String countingId;

    @JsonProperty("type")
    private String type;

    @JsonProperty("usedCount")
    private int usedCount;

    @JsonProperty("affected")
    private List<AffectedItem> affected;

    @JsonProperty("argument")
    private Argument argument;

    // Getters and Setters for all fields.
}

class AffectedItem {
    @JsonProperty("type")
    private String type;

    @JsonProperty("id")
    private String id;

    // Getters and Setters for all fields.
}

class Argument {
    @JsonProperty("countbound")
    private String countbound;

    @JsonProperty("tokenbound")
    private String tokenbound;

    // Getters and Setters for all fields.
}

class EnabledModule {
    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("totalUsage")
    private int totalUsage;

    @JsonProperty("remainingUsage")
    private int remainingUsage;

    @JsonProperty("effectiveTime")
    private String effectiveTime;

    @JsonProperty("expiredTime")
    private String expiredTime;

    @JsonProperty("actions")
    private List<Object> actions; // Assuming this could be a list of some specific objects

    // Getters and Setters for all fields.
}

class CustomAttribute {
    // Define custom attribute fields if available
}