package com.digiwin.athena.adt.domain.dto.km;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/6/11 15:43
 * @Description:
 */
@Data
public class KMCollectStepResDTO implements Serializable {

    private String boardId;

    private String question;

    private String sceneCode;

    private String appCode;

    private List<String> metricIdList;

    private String groupId;

    private String groupValue;

    private String groupType;

    private Integer showType;

    private String snapshotId;

    private Map<String,Object> solutionStep;

    private String questionId;

    private List<String> datasetList;

    private List<Map<String,Object>> stepFilterAnalysis;

    private boolean filterAnalysis;

    public static KMCollectStepResDTO builderCollectStepBySnapShotInfo(SnapShotDTO snapshotInfo,Integer showType) {
        KMCollectStepResDTO res = new KMCollectStepResDTO();
        try{
            res.setSolutionStep(snapshotInfo.getContext().getBizParams().getDataset());
            res.setAppCode(snapshotInfo.getContext().getBizParams().getAppCode());
            res.setShowType(showType);
        }catch (Exception e){
            throw new BusinessException("builderCollectStepBySnapShotInfo is error : "
                    + JsonUtils.objectToString(snapshotInfo));
        }
        return res;
    }

}
