package com.digiwin.athena.adt.domain.dto.km;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;

import java.util.List;
import java.util.Map;


/**
 * 看板配置信息
 */
@Data
public class ThemeMapBoardDTO {

    /**
     * 看板ID
     */
    private String boardId;


    /**
     * 问题ID
     */
    private String questionId;

    /**
     * 问题
     */
    private String question;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 呈现类型
     */
    private Integer showType;

    /**
     * 解决步骤
     */
    private Map<String,Object> solutionStep;


    private String appCode;

    private List<Map<String,Object>> stepFilterAnalysis;

    private boolean filterAnalysis;

    /**
     * 自定义标题
     */
    private String chartTitle;

    /**
     * 数据参数
     */
    private Map<String,Object> dataParam;

    /**
     * 数据入口
     */
    private String dataEntry;

    /**
     * show type
     * setSolutionStep
     * appCode
     * @return
     */
    public static ThemeMapBoardDTO builderThemeMapBoardBySnapShotInfo(SnapShotDTO snapshotInfo,Integer showType) {
        ThemeMapBoardDTO res = new ThemeMapBoardDTO();
        try{
            res.setSolutionStep(snapshotInfo.getContext().getBizParams().getDataset());
            res.setAppCode(snapshotInfo.getContext().getBizParams().getAppCode());
            res.setShowType(showType);
        }catch (Exception e){
            throw new BusinessException("builderThemeMapBoardBySnapShotInfo is error :"
                    + JsonUtils.objectToString(snapshotInfo));
        }
        return res;
    }
}
