package com.digiwin.athena.adt.domain.dto.mongo;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * 图表快照：用于存储图表转换后的快照数据
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document("agile_data_chart_snapshot")
public class AgileDataChartSnapshot implements Serializable {

    @Id
    private String id;

    /** 快照ID */
    @NotBlank(message = "snapshotId不能为空")
    private String snapshotId;

    /** 图表呈现类型 */
    @NotBlank(message = "chartType不能为空")
    private String chartType;

    /** 快照内容，结构需与 templateJson.json 保持一致 */
    @NotEmpty(message = "snapshotContent不能为空")
    private JSONObject snapshotContent;
}
