package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.util.CommonUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/5/20 15:53
 * @Description: limit
 */
@Data
public class ConditionStatisticsLimit implements Serializable {

    private String statisticalMethod;

    private String startPos;

    private String endPos;

    private String direction;

    public static Map<String, Object> builderLimit(QuerySchemaDebugDTO querySchemaDebugDTO) {
        ConditionStatisticsLimit limit = new ConditionStatisticsLimit();
        String limitValue = String.valueOf(Integer.parseInt(querySchemaDebugDTO.getLimitValue()) - 1);
        limit.setStatisticalMethod("limit");
        limit.setStartPos("0");
        limit.setEndPos(limitValue);
        limit.setDirection("head");
        return CommonUtil.convertObjectToMap(limit);
    }
}
