package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.util.CommonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/5/20 14:17
 * @Description:
 */
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class QuerySchemaConditionItem implements Serializable {

    private String op;

    private String left;

    @JsonProperty("left_date_format")
    private String left_date_format;

    @JsonProperty("right_value_type")
    private String right_value_type;

    private String right;

    private String type;

    @JsonProperty("logittype")
    private String logitType;

    @JsonProperty("right_date_format")
    private String right_date_format;

    @JsonProperty("left_value_type")
    private String left_value_type;

    public static Map<String,Object> builderGte(QuerySchemaDebugDTO querySchemaDebugDTO) {
        QuerySchemaConditionItem gtl = new QuerySchemaConditionItem();
        gtl.setOp("gte");
        gtl.setLeft(querySchemaDebugDTO.getTimeName());
        gtl.setLeft_date_format("yyyy-MM-dd");
        gtl.setLeft_value_type("datetime");
        gtl.setRight(querySchemaDebugDTO.getTimeStart());
        gtl.setRight_date_format("yyyy-MM-dd");
        gtl.setRight_value_type("datetime");
        gtl.setLogitType("single");
        gtl.setType("constant");
        return CommonUtil.convertObjectToMap(gtl);
    }

    public static Map<String,Object> builderLte(QuerySchemaDebugDTO querySchemaDebugDTO) {
        QuerySchemaConditionItem lte = new QuerySchemaConditionItem();
        lte.setOp("lte");
        lte.setLeft(querySchemaDebugDTO.getTimeName());
        lte.setLeft_date_format("yyyy-MM-dd");
        lte.setLeft_value_type("datetime");
        lte.setRight(querySchemaDebugDTO.getTimeEnd());
        lte.setRight_date_format("yyyy-MM-dd");
        lte.setRight_value_type("datetime");
        lte.setLogitType("single");
        lte.setType("constant");
        return CommonUtil.convertObjectToMap(lte);
    }

    @Data
    public static class QuerySchemaConditionDemission implements Serializable {
        private String op;

        private String left;

        @JsonProperty("right_value_type")
        private String right_value_type;

        private String right;

        private String type;

        @JsonProperty("logittype")
        private String logitType;

        @JsonProperty("left_value_type")
        private String left_value_type;

        public static Map<String,Object> builderDemission(QuerySchemaDebugDTO querySchemaDebugDTO) {
            QuerySchemaConditionDemission demission = new QuerySchemaConditionDemission();
            demission.setOp("eq");
            demission.setLeft(querySchemaDebugDTO.getDimensionName());
            demission.setLeft_value_type("string");
            demission.setRight(querySchemaDebugDTO.getDimensionValue());
            demission.setRight_value_type("string");
            demission.setLogitType("single");
            demission.setType("constant");
            return CommonUtil.convertObjectToMap(demission);
        }
    }
}
