package com.digiwin.athena.adt.domain.echo;

import com.digiwin.athena.adt.domain.dto.AgileDataFileShowDTO;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 16:27
 * @Description:
 */
public interface EchoService {

        /**
         * 非业务类异常上报
         * @param echoSubmitReq 入参
         * @param token token
         * @param tenantId 租户
         */
        void echoSubmit(EchoSubmitReq echoSubmitReq,String token,String tenantId);

        /**
         * 业务类异常上报
         * @param echoSubmitReq 入参
         * @param token token
         * @param tenantId 租户
         */
        void echoMongodbSubmit(EchoSubmitReq echoSubmitReq,String token,String tenantId);

        /**
         * 体验次数扣减
         * @return
         */
        Boolean echoChangeCharging(String token,String tenantId);

        /**
         * metric 上报
         * @param request request 入参
         * @param token token
         * @param tenantId 租户
         */
        void sendMetricDebugMessage(Map<String,Object> request, String token, String tenantId);

        /**
         * 新增ppt问句规划
         * @param agileDataFileDTO
         * @param token
         * @param tenantId
         * @return
         */
        Boolean addAgileDataFile(AgileDataFileDTO agileDataFileDTO, String token, String tenantId);


        /**
         * 更新ppt信息
         * @param agileDataFileDTO
         * @param token
         * @param tenantId
         * @return
         */
        Boolean updateAgileDataFile(AgileDataFileDTO agileDataFileDTO, String token, String tenantId);

        /**
         * 获取问句规划信息
         * @param params
         * @param token
         * @param tenantId
         * @return
         */
        AgileDataFileDTO getAgileDataFile(Map<String,Object> params, String token, String tenantId);

        /**
         * 删除问句规划信息
         * @param params
         * @param token
         * @param tenantId
         * @return
         */
        Boolean deleteAgileDataFile(Map<String,Object> params, String token, String tenantId);

        /**
         * 获取ppt呈现结构
         * @param params
         * @param token
         * @param tenantId
         * @return
         */
        AgileDataFileShowDTO getAgileDataFileShow(Map<String,Object> params, String token, String tenantId);

        /**
         * 更新分析师报告信息
         * @param authoredUser
         * @param agileDataAutoDataDTO
         * @return
         */
        Boolean updateAutoDataReport(AuthoredUser authoredUser, AgileDataAutoDataDTO agileDataAutoDataDTO);

        /**
         * 获取分析报告
         * @param authoredUser
         * @param autoDataDTO
         * @return
         */
        AgileDataAutoDataDTO getAutoDataReport(AuthoredUser authoredUser,AgileDataAutoDataDTO autoDataDTO);

        /**
         * 更新分析师报告信息
         * @param authoredUser
         * @param agileDataAutoDataDTO
         * @return
         */
        Boolean saveAutoDataReport(AuthoredUser authoredUser, AgileDataAutoDataDTO agileDataAutoDataDTO);

        /**
         * 更新对话看板信息
         * @param aiBoardDTO
         * @param token
         * @param tenantId
         * @return
         */
        Boolean updateAIBoard(AIBoardDTO aiBoardDTO, String token, String tenantId);

        /**
         * 获取对话看板信息
         * @param params
         * @param token
         * @param tenantId
         * @return
         */
        AIBoardDTO getAIBoard(Map<String,Object> params, String token, String tenantId);

        /**
         * 删除对话看板信息
         * @param params
         * @param token
         * @param tenantId
         * @return
         */
        Boolean deleteAIBoard(Map<String,Object> params, String token, String tenantId);

        /**
         * 保存对话看板信息
         * @param aiBoardDTO
         * @param token
         * @param tenantId
         * @return
         */
        Boolean addAIBoard(AIBoardDTO aiBoardDTO, String token, String tenantId);

        /**
         * 获取场景呈现结构
         * @param snapDataInfoDTO
         * @return
         */
        Integer getSceneShowType(SnapDataInfoDTO snapDataInfoDTO,String token, String tenantId);


}
