package com.digiwin.athena.adt.domain.file;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataEngineFileDownModel;
import com.digiwin.athena.adt.domain.dto.FileParsingPPTRes;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/29 14:28
 * @Description:
 */
public interface FileParsingService {

    AgileDataEngineFileDownModel getDmcShareUrl(String tenantId, String userToken, String locale, Map<String, Object> data);

    /**
     * 生成PPT
     * @param tenantId
     * @param userToken
     * @param locale
     * @param data
     * @return
     */
    FileParsingPPTRes getFileParsingPPT(String tenantId, String userToken, String locale, Map<String, Object> data);

    /**
     * 生成分析师报告
     * @param tenantId
     * @param userToken
     * @param locale
     * @param data
     * @return
     */
    AgileDataAutoDataReportDTO getFileParsingAutoDataReport(String tenantId, String userToken, String locale, Map<String, Object> data);
}
