package com.digiwin.athena.adt.domain.file;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataEngineFileDownModel;
import com.digiwin.athena.adt.domain.dto.FileParsingPPTRes;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/29 14:28
 * @Description:
 */
@Slf4j
@Service
public class FileParsingServiceImpl implements FileParsingService {

    @Autowired(required = false)
    private RestTemplate restTemplate;

    @Value("${fileparsing.uri:}")
    private String fileParsingUrl;

    @Override
    public AgileDataEngineFileDownModel getDmcShareUrl(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("调用fileParsing 获取url :{} ", JsonUtils.objectToString(data));

        Long startTime = System.currentTimeMillis();
        String url = fileParsingUrl + "/fileparsing/getDmcShareUrl";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",userToken);
        headers.set("userToken",userToken);
        headers.set("tenantId",tenantId);
        headers.set("locale","zh_CN");
        HttpEntity httpEntity = new HttpEntity(data,headers);
        try {
            ResponseEntity<AgileDataEngineFileDownModel> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<AgileDataEngineFileDownModel>() {
                    });
            log.info("调用 fileParsing  返参：{}, 耗时:{}", JsonUtils.objectToString(response),
                    (getQuerySchemaTook - startTime) + "毫秒");
            return response.getBody();
        } catch (Exception e){

        }
        return null;
    }

    @Override
    public FileParsingPPTRes getFileParsingPPT(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("调用fileParsing生成ppt 获取url :{} ", JsonUtils.objectToString(data));

        Long startTime = System.currentTimeMillis();
        String url = fileParsingUrl + "/fileparsing/getPPTDmcShareUrl";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",userToken);
        headers.set("userToken",userToken);
        headers.set("tenantId",tenantId);
        headers.set("locale","zh_CN");
        HttpEntity httpEntity = new HttpEntity(data,headers);
        try {
            ResponseEntity<FileParsingPPTRes> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<FileParsingPPTRes>() {
                    });
            log.info("调用 fileParsing  返参：{}, 耗时:{}", JsonUtils.objectToString(response),
                    (getQuerySchemaTook - startTime) + "毫秒");
            return response.getBody();
        } catch (Exception e){

        }
        return null;
    }

    @Override
    public AgileDataAutoDataReportDTO getFileParsingAutoDataReport(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("调用fileParsing生成分析师报告 获取url :{} ", JsonUtils.objectToString(data));

        Long startTime = System.currentTimeMillis();
        String url = fileParsingUrl + "/fileparsing/getDmcUrlByMarkDown";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",userToken);
        headers.set("userToken",userToken);
        headers.set("tenantId",tenantId);
        headers.set("locale","zh_CN");
        HttpEntity httpEntity = new HttpEntity(data,headers);
        try {
            ResponseEntity<AgileDataAutoDataReportDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<AgileDataAutoDataReportDTO>() {
                    });
            log.info("调用 fileParsing生成分析师报告  返参：{}, 耗时:{}", JsonUtils.objectToString(response),
                    (getQuerySchemaTook - startTime) + "毫秒");
            return response.getBody();
        } catch (Exception e){

        }
        return null;
    }
}
