package com.digiwin.athena.adt.domain.iam.Impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.dto.iam.AthenaUserDto;
import com.digiwin.athena.adt.domain.iam.AdtIAMAService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/8/21 18:58
 * @Description: iam 用户信息
 */
@Slf4j
@Service
public class IAMServiceImpl implements AdtIAMAService {

    @Autowired
    private RestTemplate restTemplate;

    @Value("${athena.auth.appToken}")
    private String appToken;

    @Value("${iam.uri:}")
    private String iamUrl;

    @Override
    public AthenaUserDto getUserInfoByUserId(String token, String userId, boolean queryLanguage) {
        Map<String ,Object> param = new HashMap<>();
        param.put("id", userId);
        String url = iamUrl + "/api/iam/v2/user/full";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", appToken);
        headers.add("Content-Type", "application/json");
        HttpEntity<Map<String ,Object>> httpEntity = new HttpEntity<>(param, headers);
        log.info("调用iam接口用用户id查询用户信息,url:{},entity:{}", url, JsonUtils.objectToString(httpEntity));
        try {
            ResponseEntity<BaseResultDTO<AthenaUserDto>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<AthenaUserDto>>() {
                    });
            log.info("调用iam接口用用户id查询用户信息,url:{},result:{}", url, JsonUtils.objectToString(respEntity));
            return respEntity.getBody().getResponse();
        }catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.IAM_USER_INFO_FAIL.getErrCode()
                    , e.getMessage()
                    , e.getMessage());
            throw ErrorCodeEnum.IAM_USER_INFO_FAIL.getBusinessException();
        }
    }

    public String getRealTimeTenantToken(String tenantId) {
        Map<String,Object> param = new HashMap<>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");

        String url = iamUrl + "/api/iam/v2/identity/login/internal";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("digi-middleware-auth-app", appToken);
        httpHeaders.add("Client-Agent", "mobileplatform-2.0.1.1");
        httpHeaders.add("Content-Type", "application/json");
        HttpEntity<String> httpEntity = new HttpEntity<>(JsonUtils.objectToString(param), httpHeaders);
        log.info("调用iam接口,获取租户token#pre,url:{},httpEntity:{}", url, JsonUtils.objectToString(httpEntity));
        ResponseEntity<Map<String,Object>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<Map<String,Object>>() {
                });
        log.info("调用iam接口,获取租户token#post,url:{},response:{}", url, JsonUtils.objectToString(response));
        String tenantToken =  String.valueOf(response.getBody().get("token"));
        if (StringUtils.isEmpty(tenantToken)) {
            log.error("调用iam接口,获取租户token异常");
            throw new IllegalArgumentException(String.format("获取IAM集成账号租户token:%s接口异常", "getTenantToken"));
        }
        return tenantToken;
    }
}
