package com.digiwin.athena.adt.domain.knowledge.Impl;

import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.km.*;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Slf4j
@Service
public class KmServiceImpl implements KmService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${athena.auth.appToken}")
    private String appToken;

    @Autowired
    private EchoService echoService;

    @Autowired
    private UserService userService;

    @Override
    public KMScencDTO getKmSceneInfo(AthenaMessageEvent event,String code,String local,String token,String routerkey) {
        long getQuerySchemaTook = System.currentTimeMillis();
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneMaps";
        HttpHeaders headers = new HttpHeaders();
        if(StringUtils.isNotEmpty(local)){
            headers.set("locale", local);
        }
        if(StringUtils.isNotEmpty(token)){
            headers.set("token",token);
        }
        if(StringUtils.isNotEmpty(routerkey)){
            headers.set("Routerkey",routerkey);
        }
        Map<String, String> param = new HashMap<>();
        param.put("code", code);
        HttpEntity httpEntity = new HttpEntity<>(param, headers);
        try {
            ResponseEntity<BaseResultDTO<KMScencDTO>> response = restTemplate
                    .exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<KMScencDTO>>() {
            });
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    BusinessConstants.ERROR_SEND_KM,
                    BusinessConstants.ERROR_KM_TIME_OUT,
                    code,
                    BusinessConstants.ERROR_SEND_MESSAGE);
            echoService.echoSubmit(EchoSubmitReq.init(event, BusinessConstants.ERROR_KM,
                            code,BusinessConstants.ERROR_SEND_MESSAGE,"1"),
                    token, routerkey);
            throw ErrorCodeEnum.KM_GET_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            log.error("{}, 请求code：{}, 报错信息：{} ", ErrorCodeEnum.KM_GET_TITLE_FAIL.getErrCode(),code, e.getMessage());
            throw ErrorCodeEnum.KM_GET_TITLE_FAIL.getBusinessException();
        }
    }

    @Override
    public KMScencDTO getKmSceneCode(Map<String, Object> params, String local,String token) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneByTemplateAndTarget";
        HttpHeaders headers = new HttpHeaders();
        if(StringUtils.isNotEmpty(token)){
            headers.set("token",token);
        }
        if(StringUtils.isNotEmpty(local)){
            headers.set("locale", local);
        }
        HttpEntity httpEntity = new HttpEntity<>(params, headers);
        try {
            ResponseEntity<BaseResultDTO<KMScencDTO>> response = restTemplate
                    .exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<KMScencDTO>>() {
            });
            return response.getBody().getResponse();
        } catch (Exception e){
            log.error("{}, 请求code：{}, 报错信息：{} ", "获取KM场景失败",params, e.getMessage());
        }
        return null;
    }

    @Override
    public List<KMPurchaseModelResDTO> queryKmPurchaseList(Integer type,String token, String tenantId,String userId) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/userMetricApplication?type=" + type +"&userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        HttpEntity httpEntity = new HttpEntity(headers);
        log.info("计费业务 查询当前用户应用所有信息 入参:{} ,租户：{} ,token:{}", JsonUtils.objectToString(url),tenantId,token);
        try {
            ResponseEntity<BaseResultDTO<List<KMPurchaseModelResDTO>>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<KMPurchaseModelResDTO>>>() {
                    });
            log.info("计费业务 查询当前用户应用所有信息 返参:{}", JsonUtils.objectToString(response));
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}:, 请求code：{}:, 报错信息：{} ", ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrMsg(),
                    ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrCode(), e.getMessage());
            throw ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getBusinessException();
        }
        return Collections.emptyList();
    }

    @Override
    public KMUserAppCodesResDTO queryKmUserAppCodes(String token, String tenantId,String userId) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/userAppAuth?userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        HttpEntity httpEntity = new HttpEntity(headers);
        log.info("计费业务 查询当前用户流量包应用信息 入参:{},user:{}", JsonUtils.objectToString(httpEntity),userId);
        try {
            ResponseEntity<BaseResultDTO<KMUserAppCodesResDTO>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<KMUserAppCodesResDTO>>() {
                    });
            log.info("计费业务 查询当前用户流量包应用信息 返参:{}", JsonUtils.objectToString(response));
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}:, 请求code：{}:, 报错信息：{} ", ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrMsg(),
                    ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getErrCode(), e.getMessage());
            throw ErrorCodeEnum.KM_GET_PURCHASE_FAIL.getBusinessException();
        }
        return new KMUserAppCodesResDTO();
    }

    /**
     * 根据租户查询所有指标和场景编码集合
     * @param token token
     * @param tenantId 租户id
     * @return
     */
    @Override
    public List<String> querySceneByTenantId(String token, String tenantId) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        log.info("querySceneByTenantId tenantId:{}", tenantId);
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/querySceneByTenantId";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", token);
        headers.set("Digi-Middleware-Auth-App", appToken);
        HttpEntity httpEntity = new HttpEntity(params, headers);
        try {
            ResponseEntity<BaseResultDTO<List<String>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<String>>>() {
                    });
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "querySceneByTenantId 失败", tenantId, e.getMessage());
        }
        return null;
    }

    @Override
    public List<KMApplicationApcResDTO> queryApplicationByCode(AuthoredUser user, String code) {
        Map<String,Object> params = new HashMap<>();
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/queryApplicationByCode";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", appToken);
        HttpEntity httpEntity = new HttpEntity(params, headers);
        params.put("sceneCode",code);
        try {
            ResponseEntity<BaseResultDTO<List<KMApplicationApcResDTO>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<KMApplicationApcResDTO>>>() {
                    });
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "queryApplicationByCode 失败", code, e.getMessage());
        }
        return null;
    }


    /**
     * 2.0 数据源指令集信息和开场白信息
     * @param user 用户
     * @param appCode 应用编码
     * @return 数据源信息
     */
    @Override
    public KMDatasetCommandIntentionsResDTO dataSetCommandIntentions(AuthoredUser user, String appCode,String version) {
        // 获取用户语言别
        String userLocale = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/command/dataSetCommandIntentions?appCode="
                + appCode + "&version=" + version;
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", appToken);
        headers.set("locale", userLocale);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<BaseResultDTO<KMDatasetCommandIntentionsResDTO>> response = restTemplate
                    .exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<KMDatasetCommandIntentionsResDTO>>() {
                    });
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "dataSetCommandIntentions 失败", appCode, e.getMessage());
        }
        return null;
    }

    /**
     * 获取数据集列表
     * @param user 用户
     * @param appCode 应用编码
     * @return 数据集列表
     */
    @Override
    public List<KMDataSetResDTO> queryDataSetsByAppCode(AuthoredUser user, String appCode,String userLang) {

        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/scene/queryDataSetsByApp";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", userLang);
        Map<String,Object> params = new HashMap<>();
        params.put("appCode",appCode);
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            ResponseEntity<BaseResultDTO<List<KMDataSetResDTO>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<KMDataSetResDTO>>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "queryDataSetsByAppCode 失败", appCode, e.getMessage());

        }
        return null;
    }

    @Override
    public ThemeMapBoardDTO getThemeMapBoardQuestion(AuthoredUser user,String questionId) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataBoard/queryBoardStep";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        Map<String, Object> params = Maps.newHashMap();
        params.put("questionId",questionId);
        HttpEntity httpEntity = new HttpEntity<Map>(params, headers);
        try {
            ResponseEntity<BaseResultDTO<ThemeMapBoardDTO>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<ThemeMapBoardDTO>>() {
                    });
            log.info("获取看板问题信息返参：{}", JsonUtils.objectToString(response));
            return Objects.requireNonNull(response.getBody()).getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public String getVersion(AuthoredUser user) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenant/tenantVersion?tenantId="
                + user.getTenantId();
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", appToken);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<BaseResultDTO<String>> response = restTemplate
                    .exchange(url, HttpMethod.GET, httpEntity,
                            new ParameterizedTypeReference<BaseResultDTO<String>>() {
                            });
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "getVersion 失败", user.getTenantId(), e.getMessage());
        }
        return null;
    }

    @Override
    public Map<String,Object> updateCollectByConfig(AuthoredUser user, KMCollectConfigReqDTO kmCollectConfigReqDTO) {

        String url = envProperties.getKnowledgeGraphUri()
                + "knowledgegraph/dataSubscription/updateSubscriptionByConfig"
                + user.getTenantId();
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", appToken);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String,Object>>> response = restTemplate
                    .exchange(url, HttpMethod.GET, httpEntity,
                            new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>() {
                            });
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}, 请求code：{}, 报错信息：{} ", "updateCollectByConfig 失败", user.getTenantId(), e.getMessage());
        }
        return null;
    }

    @Override
    public KMCollectStepResDTO getCollectStep(AuthoredUser user, String questionId) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataCollect/queryCollectStep";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        Map<String, Object> params = Maps.newHashMap();
        params.put("questionId",questionId);
        HttpEntity httpEntity = new HttpEntity<Map>(params, headers);
        try {
            ResponseEntity<BaseResultDTO<KMCollectStepResDTO>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<KMCollectStepResDTO>>() {
                    });
            log.info("获取看板问题信息返参：{}", JsonUtils.objectToString(response));
            return Objects.requireNonNull(response.getBody()).getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public List<KMCommandIntentionsDTO> queryCommandIntentions(AuthoredUser user) {
        // 获取用户语言别
        String userLocale = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/command/queryAllCommandIntentions?userId=" + user.getUserId();
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", userLocale);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<BaseResultDTO<List<KMCommandIntentionsDTO>>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<KMCommandIntentionsDTO>>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);

        }
        return Collections.emptyList();
    }

    @Override
    public Map<String,Object> addBoardInfo(AuthoredUser user, AgileDataQueryBoardAddDTO boardAddDTO) {
        // 获取用户语言别
        String userLocale = userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/dataBoard/addDataBoardConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", userLocale);
        HttpEntity httpEntity = new HttpEntity(boardAddDTO,headers);
        try {
            ResponseEntity<Map<String,Object>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<Map<String,Object>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody();
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);

        }
        return null;
    }

    @Override
    public AgileDataQueryDataConfig queryDataConfig(AuthoredUser user, String appCode,String locale) {
        String url = envProperties.getKnowledgeGraphUri() + "agiledataquery/dataConfig/info";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.add(GlobalConstant.ROUTER_KEY, user.getTenantId());
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        Map<String,Object> params = Maps.newHashMap();
        params.put("appCode",appCode);
        params.put("tenantId",user.getTenantId());
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            ResponseEntity<BaseResultDTO<AgileDataQueryDataConfig>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<AgileDataQueryDataConfig>>() {
                    });
            log.info("获取敏数问数配置信息返参：{}", JsonUtils.objectToString(response));
            return Objects.requireNonNull(response.getBody()).getResponse();
        } catch (Exception e) {
            log.error("获取敏数租户级配置失败，{}", e.getMessage());

        }
        return null;
    }
}
