package com.digiwin.athena.adt.domain.repository.mongo.impl;

import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.adt.domain.repository.mongo.AgileDataChartSnapshotRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.util.Objects;

@Repository("agileDataChartSnapshotRepository")
public class AgileDataChartSnapshotRepositoryImpl implements AgileDataChartSnapshotRepository {

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    private static final String COLLECTION = "agile_data_chart_snapshot";

    @Override
    public void saveOrUpdate(AgileDataChartSnapshot snapshot) {
        Query query = Query.query(Criteria.where("snapshotId").is(snapshot.getSnapshotId()).and("chartType").is(snapshot.getChartType()));
        AgileDataChartSnapshot exist = mongoAgileDataPageViewTemplate.findOne(query, AgileDataChartSnapshot.class, COLLECTION);
        if (Objects.isNull(exist)) {
            mongoAgileDataPageViewTemplate.insert(snapshot, COLLECTION);
        } else {
            Update update = new Update();
            update.set("chartType", snapshot.getChartType());
            update.set("snapshotContent", snapshot.getSnapshotContent());
            mongoAgileDataPageViewTemplate.upsert(query, update, AgileDataChartSnapshot.class, COLLECTION);
        }
    }

    @Override
    public AgileDataChartSnapshot findBySnapshotIdAndChartType(String snapshotId, String chartType) {
        Query query = Query.query(Criteria.where("snapshotId").is(snapshotId).and("chartType").is(chartType));
        return mongoAgileDataPageViewTemplate.findOne(query, AgileDataChartSnapshot.class, COLLECTION);
    }
}