package com.digiwin.athena.adt.domain.tdd.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.dto.tdd.TddThresholdConfig;
import com.digiwin.athena.adt.domain.dto.tdd.TddThresholdRes;
import com.digiwin.athena.adt.domain.tdd.TddService;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 15:28
 * @Description:
 */
@Slf4j
@Service
public class TddServiceImpl implements TddService {

    @Autowired(required = false)
    private RestTemplate restTemplate;

    @Value("${tdd.url:}")
    private String tddUrl;

    @Override
    public TddThresholdConfig getTddThresholdConfigByParam(String token ,String tid, String appCode) {
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info("查询tdd 流量阈值配置 入参 tid :{} goodsCode:{}",tid,appCode);
        String url= tddUrl +"/appThresholdConfigController/getOne?tid=" + tid + "&code="+ appCode;
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",token);
        headers.set("routerkey",tid);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);

        try {
            ResponseEntity<TddThresholdRes> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<TddThresholdRes>() {
                    });
            log.info("查询tdd 流量阈值配置 返参：{}" , JsonUtils.objectToString(responseEntity));
            if(responseEntity.getStatusCode().value() != 200
                    || responseEntity.getBody() == null || !"0".equals(responseEntity.getBody().getCode())
                    || responseEntity.getBody().getData() == null ){
                return null;
            }
            return responseEntity.getBody().getData();
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->获取当前用户指定应用的授权信息(TDD) getTddThresholdConfigByParam",
                    "调用CAC接口超时 ResourceAccessException",
                    appCode,
                    "请联系平台处理");
            throw ErrorCodeEnum.TDD_REALTIME_FAIL.getBusinessException();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.TDD_GET_FAIL.getErrCode()
                    , appCode
                    , e.getMessage());
            throw ErrorCodeEnum.TDD_GET_FAIL.getBusinessException();
        }
    }
}
