package com.digiwin.athena.adt.domain.uibot.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.uibot.UIBOTService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class UIBOTServiceImpl implements UIBOTService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Map<String, Object> compensateAgileData(Map<String, Object> pullData) {
        String url = envProperties.getUibotUri() + "/api/ai/v1/agile/report/compensate/data";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity<>(pullData, headers);
        try {
                log.info("请求补偿数据，数据信息:{}",JsonUtils.objectToString(pullData));
            ResponseEntity<BaseResultDTO<Map<String,Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>() {
                    });
            return response.getBody().getResponse();
        } catch (Exception ex) {
            log.error("{}, 请求补偿指标卡body：{}, 报错信息：{} ", ErrorCodeEnum.UIBOT_DATA_AGILEDATA_FAIL.getErrCode(), JsonUtils.objectToString(pullData), ex);
        }
        return null;
    }
}
