package com.digiwin.athena.adt.sse.domain;

import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;


/**
 * SSE完成回调组件
 */
public class SseEmitterCompletionCallbackComponent implements Runnable{

    private SSEBaseEvent sseBaseEvent;

    public SseEmitterCompletionCallbackComponent(SSEBaseEvent sseBaseEvent){
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void run() {
        //标记事件结束
        sseBaseEvent.setIsOver(true);
        //断开语义监听
        if(!sseBaseEvent.getIsScrumOver()){
            sseBaseEvent.getScrumEventSource().cancel();
        }
    }
}
